/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.osgi.framework.Bundle;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ResourceDescriptor;

public class ResourceDescriptorImpl
implements ResourceDescriptor {
    private Bundle factoryBundle;
    private String factoryClassName;
    private final String uniqueID;
    private final List protocols;
    private final List extensions;

    public ResourceDescriptorImpl(String uniqueID) {
        CoreArgCheck.isNotNull((Object)uniqueID);
        CoreArgCheck.isNotZeroLength((String)uniqueID);
        this.uniqueID = uniqueID;
        this.protocols = new ArrayList();
        this.extensions = new ArrayList();
    }

    @Override
    public String getUniqueIdentifier() {
        return this.uniqueID;
    }

    @Override
    public List getExtensions() {
        return this.extensions;
    }

    @Override
    public List getProtocols() {
        return this.protocols;
    }

    @Override
    public Resource.Factory getResourceFactory() throws ModelerCoreException {
        try {
            Class factoryClass = this.factoryBundle.loadClass(this.factoryClassName);
            return (Resource.Factory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            Object[] params = new Object[]{this.factoryClassName, this.factoryBundle};
            throw new ModelerCoreException((Throwable)e, ModelerCore.Util.getString("ResourceDescriptorImpl.Unable_to_load_class_using_bundle", params));
        }
        catch (InstantiationException e) {
            Object[] params = new Object[]{this.factoryClassName, this.factoryBundle};
            throw new ModelerCoreException((Throwable)e, ModelerCore.Util.getString("ResourceDescriptorImpl.Unable_to_instantiate_class_using_bundle", params));
        }
        catch (IllegalAccessException e) {
            Object[] params = new Object[]{this.factoryClassName, this.factoryBundle};
            throw new ModelerCoreException((Throwable)e, ModelerCore.Util.getString("ResourceDescriptorImpl.Unable_to_instantiate_and_access_class_using_bundle", params));
        }
    }

    public void setResourceFactoryClass(String className) {
        this.setResourceFactoryClass(className, null);
    }

    public void setResourceFactoryClass(String className, Bundle bundle) {
        if (className == null) {
            CoreArgCheck.isNotNull((Object)className, (String)ModelerCore.Util.getString("ResourceDescriptorImpl.The_class_name_string_may_not_be_null", new Object[0]));
        }
        if (bundle != null) {
            this.factoryBundle = bundle;
        }
        this.factoryClassName = className;
    }

    protected String getResourceFactoryClassName() {
        return this.factoryClassName;
    }

    public static void register(ResourceDescriptor resourceDescriptor, ResourceSet resourceSet) throws ModelerCoreException {
        List protocols = resourceDescriptor.getProtocols();
        List fileExtensions = resourceDescriptor.getExtensions();
        String factoryExtensionID = resourceDescriptor.getUniqueIdentifier();
        if (protocols.size() != 0 || fileExtensions.size() != 0) {
            try {
                Resource.Factory factory = resourceDescriptor.getResourceFactory();
                String factoryClassName = factory.getClass().getName();
                Resource.Factory.Registry registry = resourceSet.getResourceFactoryRegistry();
                Map extensionToFactoryMap = registry.getExtensionToFactoryMap();
                Map protocolToFactoryMap = registry.getProtocolToFactoryMap();
                for (String protocol : protocols) {
                    Resource.Factory prevFactory;
                    if (ModelerCore.DEBUG) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("ResourceDescriptorImpl.DEBUG.Registering_resource_factory_for_URI_protocol", new Object[]{factoryClassName, protocol}));
                    }
                    if ((prevFactory = protocolToFactoryMap.put(protocol, factory)) == null || prevFactory.getClass() == factory.getClass()) continue;
                    ModelerCore.Util.log(2, ModelerCore.Util.getString("ResourceDescriptorImpl.Replaced_resource_factory_for_URI_protocol", new Object[]{prevFactory.getClass().getName(), factoryClassName, protocol}));
                }
                for (String fileExtension : fileExtensions) {
                    Resource.Factory prevFactory;
                    if (ModelerCore.DEBUG) {
                        ModelerCore.Util.log(1, ModelerCore.Util.getString("ResourceDescriptorImpl.DEBUG.Registering_resource_factory_for_URI_extension", new Object[]{factoryClassName, fileExtension}));
                    }
                    if ((prevFactory = extensionToFactoryMap.put(fileExtension, factory)) == null || prevFactory.getClass() == factory.getClass()) continue;
                    ModelerCore.Util.log(2, ModelerCore.Util.getString("ResourceDescriptorImpl.Replaced_resource_factory_for_URI_extension", new Object[]{prevFactory.getClass().getName(), factoryClassName, fileExtension}));
                }
            }
            catch (CoreException coreException) {
                String msg = ModelerCore.Util.getString("ResourceDescriptorImpl.Error_while_loading_resource_factory_extension", (Object)factoryExtensionID);
                throw new ModelerCoreException(msg);
            }
        }
    }

    public boolean equals(Object obj) {
        ResourceDescriptorImpl that = (ResourceDescriptorImpl)obj;
        if (!this.uniqueID.equals(that.uniqueID)) {
            return false;
        }
        if (!this.factoryClassName.equals(that.factoryClassName)) {
            return false;
        }
        if (!this.protocols.containsAll(that.protocols) || !that.protocols.containsAll(this.protocols)) {
            return false;
        }
        if (!this.extensions.containsAll(that.extensions) || !that.extensions.containsAll(this.extensions)) {
            return false;
        }
        return this.factoryBundle.equals(that.factoryBundle);
    }

    public int hashCode() {
        return this.uniqueID.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ResourceDescriptor ");
        sb.append(this.uniqueID);
        sb.append(" protocols=[");
        boolean first = true;
        Iterator iter = this.protocols.iterator();
        while (iter.hasNext()) {
            if (!first) {
                sb.append(',');
            }
            sb.append(iter.next());
            first = false;
        }
        sb.append("], extensions=[");
        first = true;
        iter = this.extensions.iterator();
        while (iter.hasNext()) {
            if (!first) {
                sb.append(',');
            }
            sb.append(iter.next());
            first = false;
        }
        sb.append(']');
        return sb.toString();
    }
}

