/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.extension.definition.ExtendableMetaclassNameProvider;

public abstract class AbstractMetaclassNameProvider
implements ExtendableMetaclassNameProvider {
    private static final String MC_PREFIX = ".impl.";
    private static final String MC_SUFFIX = "Impl";
    protected static final String[] NO_PARENTS = new String[0];
    private final List<String> metaclassNames;
    private final String metamodelUri;
    private final Map<String, List<String>> parentChildMap;
    private final List<String> roots;

    public static final String getLabel(String metaclassName) {
        CoreArgCheck.isNotEmpty((String)metaclassName);
        int index1 = metaclassName.indexOf(MC_PREFIX);
        if (index1 == -1) {
            index1 = metaclassName.lastIndexOf(".");
            if (index1 != -1) {
                return metaclassName.substring(index1 + 1);
            }
        } else {
            int index2 = metaclassName.indexOf(MC_SUFFIX);
            if (index1 != -1) {
                return metaclassName.substring(index1 + MC_PREFIX.length(), index2);
            }
        }
        return metaclassName;
    }

    protected AbstractMetaclassNameProvider(String metamodelUri) {
        CoreArgCheck.isNotEmpty((String)metamodelUri);
        this.metaclassNames = new ArrayList<String>();
        this.metamodelUri = metamodelUri;
        this.parentChildMap = new HashMap<String, List<String>>();
        this.roots = new ArrayList<String>();
    }

    protected final void addMetaclass(String metaclassName, String ... parents) {
        CoreArgCheck.isNotEmpty((String)metaclassName);
        if (!this.metaclassNames.contains(metaclassName)) {
            this.metaclassNames.add(metaclassName);
            if (parents == null || parents.length == 0) {
                this.roots.add(metaclassName);
            } else {
                String[] stringArray = parents;
                int n = parents.length;
                int n2 = 0;
                while (n2 < n) {
                    String parent = stringArray[n2];
                    List<String> kids = this.parentChildMap.get(parent);
                    if (kids == null) {
                        kids = new ArrayList<String>();
                        this.parentChildMap.put(parent, kids);
                    }
                    kids.add(metaclassName);
                    ++n2;
                }
            }
        }
    }

    public String[] getExtendableMetaclassChildren(String parentMetaclassName) {
        CoreArgCheck.isNotEmpty((String)parentMetaclassName);
        List<String> kidNames = this.parentChildMap.get(parentMetaclassName);
        if (kidNames == null || kidNames.isEmpty()) {
            return new String[0];
        }
        String[] result = new String[kidNames.size()];
        int i = 0;
        for (String kidName : kidNames) {
            result[i++] = kidName;
        }
        return result;
    }

    public String[] getExtendableMetaclassRoots() {
        return this.roots.toArray(new String[this.roots.size()]);
    }

    public final String getLabelText(String metaclassName) {
        CoreArgCheck.isNotEmpty((String)metaclassName);
        return AbstractMetaclassNameProvider.getLabel(metaclassName);
    }

    public final String getMetamodelUri() {
        return this.metamodelUri;
    }

    public String getParent(String metaclassName) {
        CoreArgCheck.isNotEmpty((String)metaclassName);
        for (Map.Entry<String, List<String>> entry : this.parentChildMap.entrySet()) {
            if (!entry.getValue().contains(metaclassName)) continue;
            return entry.getKey();
        }
        assert (false);
        return null;
    }

    public boolean hasChildren(String metaclassName) {
        CoreArgCheck.isNotEmpty((String)metaclassName);
        return this.getExtendableMetaclassChildren(metaclassName).length != 0;
    }
}

