/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.extension.deprecated;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.extension.EmfModelObjectExtensionAssistant;
import org.teiid.designer.core.util.ModelObjectClassNameVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;

public class DeprecatedModelExtensionAssistant
extends EmfModelObjectExtensionAssistant {
    public static final NamespaceProvider NAMESPACE_PROVIDER;
    private static final String REST_NAMESPACE_PREFIX = "rest";
    private static final String SOURCE_FUNCTION_NAMESPACE_PREFIX = "relational";
    private static final String NEW_PUSH_DOWN;
    private static final String NEW_REST_METHOD;
    private static final String NEW_URI;
    private static final String OLD_PUSH_DOWN;
    private static final String OLD_REST_METHOD;
    private static final String OLD_URI_1;
    private static final String OLD_URI_2;
    private ModelObjectExtensionAssistant restAssistant;
    private ModelObjectExtensionAssistant sourceFunctionAssistant;

    static {
        NamespaceProvider relationalNamespaceProvider = new NamespaceProvider(){

            public String getNamespaceUri() {
                return null;
            }

            public String getNamespacePrefix() {
                return DeprecatedModelExtensionAssistant.SOURCE_FUNCTION_NAMESPACE_PREFIX;
            }
        };
        NEW_PUSH_DOWN = ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)relationalNamespaceProvider, (String)"deterministic");
        NamespaceProvider restNamespaceProvider = new NamespaceProvider(){

            public String getNamespaceUri() {
                return null;
            }

            public String getNamespacePrefix() {
                return DeprecatedModelExtensionAssistant.REST_NAMESPACE_PREFIX;
            }
        };
        NEW_REST_METHOD = ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)restNamespaceProvider, (String)"restMethod");
        NEW_URI = ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)restNamespaceProvider, (String)"uri");
        NAMESPACE_PROVIDER = new NamespaceProvider(){

            public String getNamespaceUri() {
                return null;
            }

            public String getNamespacePrefix() {
                return "ext-custom";
            }
        };
        OLD_PUSH_DOWN = ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)NAMESPACE_PROVIDER, (String)"deterministic");
        OLD_REST_METHOD = ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)NAMESPACE_PROVIDER, (String)"REST-METHOD");
        OLD_URI_1 = ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)NAMESPACE_PROVIDER, (String)"URI");
        OLD_URI_2 = ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)NAMESPACE_PROVIDER, (String)"uri");
    }

    public void convertOldRestProperties(Object modelObject) throws Exception {
        String restMethodValue = this.getPropertyValue(modelObject, OLD_REST_METHOD);
        String uri1Value = this.getPropertyValue(modelObject, OLD_URI_1);
        String uri2Value = this.getPropertyValue(modelObject, OLD_URI_2);
        String uriValue = uri2Value == null ? uri1Value : uri2Value;
        this.removeOldRestProperties(modelObject);
        this.getRestAssistant().saveModelExtensionDefinition(modelObject);
        this.getRestAssistant().setPropertyValue(modelObject, NEW_REST_METHOD, restMethodValue);
        this.getRestAssistant().setPropertyValue(modelObject, NEW_URI, uriValue);
    }

    private ModelObjectExtensionAssistant getRestAssistant() {
        if (this.restAssistant == null) {
            this.restAssistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(REST_NAMESPACE_PREFIX);
        }
        return this.restAssistant;
    }

    private ModelObjectExtensionAssistant getSourceFunctionAssistant() {
        if (this.sourceFunctionAssistant == null) {
            this.sourceFunctionAssistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(SOURCE_FUNCTION_NAMESPACE_PREFIX);
        }
        return this.sourceFunctionAssistant;
    }

    public boolean hasOldPushdownProperties(EObject modelObject) throws Exception {
        return !CoreStringUtil.isEmpty((String)this.getOverriddenValue(modelObject, OLD_PUSH_DOWN));
    }

    public boolean hasOldRestProperties(EObject modelObject) throws Exception {
        return !CoreStringUtil.isEmpty((String)this.getOverriddenValue(modelObject, OLD_REST_METHOD));
    }

    public void removeOldRestProperties(Object modelObject) throws Exception {
        this.removeProperty(modelObject, OLD_REST_METHOD);
        this.removeProperty(modelObject, OLD_URI_1);
        this.removeProperty(modelObject, OLD_URI_2);
    }

    private void convert(Object modelObject, String oldPropId, String newPropId, ModelObjectExtensionAssistant assistant) throws Exception {
        String value = this.getPropertyValue(modelObject, oldPropId);
        if (!CoreStringUtil.isEmpty((String)value)) {
            this.removeProperty(modelObject, oldPropId);
            assistant.setPropertyValue(modelObject, newPropId, value);
        }
    }

    @Override
    public void setPropertyValue(Object modelObject, String propId, String newValue) throws Exception {
        CoreArgCheck.isInstanceOf(EObject.class, (Object)modelObject);
        CoreArgCheck.isNotEmpty((String)propId, (String)"id is empty");
        ModelResource modelResource = this.getModelResource(modelObject);
        if (modelResource == null) {
            throw new Exception(ModelerCore.Util.getString("DeprecatedModelExtensionAssistant.modelResourceNotFound", modelObject));
        }
        String className = "org.teiid.designer.metamodels.relational.impl.ProcedureImpl";
        ModelObjectClassNameVisitor visitor = new ModelObjectClassNameVisitor(Collections.singletonList(className));
        ModelVisitorProcessor processor = new ModelVisitorProcessor(visitor, 1);
        processor.walk(modelResource, 2);
        Collection<EObject> eObjects = visitor.getResult();
        if (OLD_PUSH_DOWN.equals(propId)) {
            ModelObjectExtensionAssistant assistant = this.getSourceFunctionAssistant();
            assistant.saveModelExtensionDefinition(modelObject);
            for (EObject eObject : eObjects) {
                this.convert(eObject, OLD_PUSH_DOWN, NEW_PUSH_DOWN, assistant);
                if (!modelObject.equals(eObject)) continue;
                assistant.setPropertyValue(modelObject, NEW_PUSH_DOWN, newValue);
            }
        } else if (OLD_URI_1.equals(propId) || OLD_URI_2.equals(propId) || OLD_REST_METHOD.equals(propId)) {
            ModelObjectExtensionAssistant assistant = this.getRestAssistant();
            assistant.saveModelExtensionDefinition(modelObject);
            for (EObject eObject : eObjects) {
                this.convert(eObject, OLD_REST_METHOD, NEW_REST_METHOD, assistant);
                this.convert(eObject, OLD_URI_1, NEW_URI, assistant);
                this.convert(eObject, OLD_URI_2, NEW_URI, assistant);
                if (!modelObject.equals(eObject)) continue;
                if (OLD_REST_METHOD.equals(propId)) {
                    assistant.setPropertyValue(modelObject, NEW_REST_METHOD, newValue);
                    continue;
                }
                assistant.setPropertyValue(modelObject, NEW_URI, newValue);
            }
        } else {
            ModelerCore.Util.log((Object)ModelerCore.Util.getString("DeprecatedModelExtensionAssistant.propertyNotFound", (Object)propId));
        }
    }

    @Override
    public boolean supportsMedOperation(String proposedOperationName, Object context) {
        return "SHOW_IN_REGISTRY".equals(proposedOperationName);
    }
}

