/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.DuplicateResourceException;
import org.teiid.designer.core.index.IDocument;
import org.teiid.designer.core.index.IIndexer;
import org.teiid.designer.core.index.IIndexerOutput;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.index.IndexingContext;
import org.teiid.designer.core.index.ModelDocument;
import org.teiid.designer.core.index.ModelDocumentImpl;
import org.teiid.designer.core.index.ModelSearchIndexer;
import org.teiid.designer.core.index.ResourceDocumentImpl;
import org.teiid.designer.core.index.ResourceIndexer;
import org.teiid.designer.core.index.WordEntry;
import org.teiid.designer.core.index.WordEntryComparator;
import org.teiid.designer.core.metadata.runtime.RuntimeAdapter;
import org.teiid.designer.core.util.ModelObjectCollector;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;

public class ModelIndexer
implements ResourceIndexer {
    public static boolean PRINT_INDEX_CONTENTS = false;
    private static final String[] FILE_TYPES = new String[]{"model"};
    private static String INDEX_TYPES = ModelerCore.Util.getString("ModelIndexer.Metadata_Indexes_1", new Object[0]);

    private IndexingContext createQueryContext() {
        try {
            Container container = ModelerCore.getModelContainer();
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            Object resources = workspace.isOpen() ? Arrays.asList(workspace.getEmfResources()) : container.getResources();
            IndexingContext context = new IndexingContext();
            context.setResourcesInContext((Collection)resources);
            return context;
        }
        catch (CoreException e) {
            ModelerCore.Util.log((Throwable)e);
            return null;
        }
    }

    @Override
    public String getIndexType() {
        return INDEX_TYPES;
    }

    public String[] getFileTypes() {
        return FILE_TYPES;
    }

    public void setFileTypes(String[] fileTypes) {
    }

    public boolean shouldIndex(IDocument document) {
        return document instanceof ModelDocument;
    }

    public final void index(IDocument document, IIndexerOutput output) {
        CoreArgCheck.isNotNull((Object)document);
        CoreArgCheck.isNotNull((Object)output);
        if (!this.shouldIndex(document)) {
            return;
        }
        int initialIndexSize = 10;
        List eObjects = Collections.EMPTY_LIST;
        String modelPath = null;
        if (document instanceof ModelDocument) {
            ModelDocument modelDocument = (ModelDocument)document;
            modelPath = modelDocument.getIResource().getFullPath().toString();
            Resource emfResource = modelDocument.getResource();
            ModelObjectCollector moc = new ModelObjectCollector(emfResource);
            eObjects = moc.getEObjects();
            initialIndexSize += eObjects.size();
        }
        ArrayList indexWords = new ArrayList(initialIndexSize);
        this.addResourceWordEntries(document, indexWords);
        if (document instanceof ModelDocument) {
            IndexingContext context = this.createQueryContext();
            for (EObject eObject : eObjects) {
                this.addIndexWord(eObject, context, modelPath, indexWords);
            }
        }
        this.sortWordEntries(indexWords);
        output.addDocument(document);
        this.addEntries(output, indexWords);
        if (PRINT_INDEX_CONTENTS && !(this instanceof ModelSearchIndexer)) {
            this.printWordEntryList(indexWords, System.out);
        }
        indexWords = null;
    }

    @Override
    public void indexResource(IResource resource, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        Resource emfResource;
        ModelResource mResource;
        block11: {
            CoreArgCheck.isNotNull((Object)resource);
            ModelWorkspace workspace = ModelerCore.getModelWorkspace();
            mResource = workspace.findModelResource(resource);
            emfResource = null;
            if (mResource != null) {
                try {
                    emfResource = mResource.getEmfResource();
                }
                catch (ModelWorkspaceException err) {
                    Throwable wrapped = err.getException();
                    if (wrapped instanceof DuplicateResourceException) break block11;
                    throw err;
                }
            }
        }
        IPath path = resource.getFullPath();
        try {
            String fileName = this.getIndexFileName(path);
            String indexFilePath = IndexUtil.getIndexFilePath(IndexUtil.INDEX_PATH, fileName);
            if (ModelerCore.DEBUG || ModelerCore.DEBUG_PROJECT_BUILDER) {
                Object[] params = new Object[]{fileName, path};
                String msg = ModelerCore.Util.getString("IndexUtil.DEBUG.Creating_index_file_0_for_resource_1_1", params);
                ModelerCore.Util.log(1, msg);
            }
            ResourceDocumentImpl document = null;
            if (emfResource != null) {
                document = mResource != null ? new ModelDocumentImpl(path.toFile(), resource, emfResource) : new ResourceDocumentImpl(path.toFile(), resource);
            }
            if (document != null) {
                Index runtimeIndex = IndexUtil.getNewIndexFile(fileName, indexFilePath, resource.getName());
                if (addResource) {
                    runtimeIndex.add((IDocument)document, (IIndexer)this);
                } else {
                    runtimeIndex.remove(document.getName());
                }
                runtimeIndex.save();
            }
            if (mResource != null) {
                this.setIndexType(mResource);
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.teiid.designer.core", 0, ModelerCore.Util.getString("ModelBuilder.IO_Error_trying_to_index_an_EmfResource_2", new Object[0]), (Throwable)e);
            throw new ModelerCoreException((IStatus)status);
        }
    }

    @Override
    public void indexResource(IPath path, boolean reuseExistingFile, boolean addResource) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)path);
        IFile resource = WorkspaceResourceFinderUtil.findIResourceByPath(path);
        this.indexResource((IResource)resource, reuseExistingFile, addResource);
    }

    protected void setIndexType(ModelResource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        if (resource.getIndexType() == 0) {
            resource.setIndexType(1);
        } else if (resource.getIndexType() == 2) {
            resource.setIndexType(3);
        }
    }

    protected String getIndexFileName(IPath path) {
        return IndexUtil.getIndexFileName(path.toString(), "INDEX");
    }

    protected void addIndexWord(EObject eObject, IndexingContext context, String modelPath, List wordEntries) {
        RuntimeAdapter.addIndexWord(eObject, context, modelPath, wordEntries, true);
    }

    protected void sortWordEntries(List wordEntries) {
        WordEntryComparator wComparator = new WordEntryComparator();
        Collections.sort(wordEntries, wComparator);
    }

    protected void addResourceWordEntries(IDocument document, List wordEntries) {
    }

    private void addEntries(IIndexerOutput output, List entries) {
        for (WordEntry entry : entries) {
            output.addRef(entry.getWord());
        }
    }

    private void printWordEntryList(List wordEntries, PrintStream stream) {
        for (WordEntry entry : wordEntries) {
            stream.println(entry.toString());
        }
    }
}

