/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.index.CompositeIndexSelector;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.IndexSelectorFactory;
import org.teiid.designer.core.index.ModelWorkspaceIndexSelector;
import org.teiid.designer.core.index.ResourceFileIndexSelector;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;

public class ModelWorkspaceIndexSelectorFactory
implements IndexSelectorFactory {
    @Override
    public IndexSelector createIndexSelector(List modelWorkspaceItems) throws CoreException {
        Object item;
        CoreArgCheck.isNotNull((Object)modelWorkspaceItems);
        int numItems = modelWorkspaceItems.size();
        if (numItems == 0) {
            return new ModelWorkspaceIndexSelector();
        }
        if (numItems == 1 && (item = modelWorkspaceItems.get(0)) instanceof ModelWorkspace) {
            return new ModelWorkspaceIndexSelector();
        }
        LinkedList modelResources = new LinkedList();
        Iterator iter = modelWorkspaceItems.iterator();
        while (iter.hasNext()) {
            ModelWorkspaceItem item2;
            ModelWorkspaceItem wsItem = item2 = (ModelWorkspaceItem)iter.next();
            this.doAddModelResources(wsItem, modelResources);
        }
        LinkedList<ResourceFileIndexSelector> selectors = new LinkedList<ResourceFileIndexSelector>();
        for (ModelResource modelResource : modelResources) {
            IResource resource = modelResource.getCorrespondingResource();
            String filePath = resource.getFullPath().toString();
            ResourceFileIndexSelector selector = new ResourceFileIndexSelector(filePath);
            selectors.add(selector);
        }
        if (selectors.size() == 0) {
            return new ModelWorkspaceIndexSelector();
        }
        if (selectors.size() == 1) {
            return (IndexSelector)selectors.get(0);
        }
        return new CompositeIndexSelector(selectors);
    }

    protected void doAddModelResources(ModelWorkspaceItem item, List modelResources) throws CoreException {
        if (item instanceof ModelWorkspace) {
            modelResources.add(item);
        } else if (item instanceof ModelResource) {
            modelResources.add(item);
        } else {
            ModelWorkspaceItem[] children = item.getChildren();
            int i = 0;
            while (i < children.length) {
                ModelWorkspaceItem child = children[i];
                this.doAddModelResources(child, modelResources);
                ++i;
            }
        }
    }
}

