/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.index.AbstractIndexSelector;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.DateUtil;
import org.teiid.designer.core.workspace.ModelFileUtil;

public class ResourceFileIndexSelector
extends AbstractIndexSelector {
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final Index[] EMPTY_INDEX_ARRAY = new Index[0];
    private static final Resource[] EMPTY_RESOURCE_ARRAY = new Resource[0];
    protected static final String TEMP_DIR = String.valueOf(FileUtils.TEMP_DIRECTORY) + "\\indexes";
    protected final File selectedFile;
    protected Index[] indexes;
    protected String indexDirectoryPath;

    public ResourceFileIndexSelector(String filepath) throws ModelerCoreException {
        if (filepath == null) {
            CoreArgCheck.isNotNull((Object)filepath, (String)ModelerCore.Util.getString("ResourceFileIndexSelector.The_filepath_string_may_not_be_null_1", new Object[0]));
        }
        this.selectedFile = new File(filepath);
        if (!this.selectedFile.exists()) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("ResourceFileIndexSelector.The_specified_file_does_not_exist._2", (Object)filepath));
        }
        if (FileUtils.isArchiveFileName((String)filepath)) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("ResourceFileIndexSelector.Building_indexes_from_resource_found_in_archive_._3", (Object)filepath));
        } else if (this.selectedFile.isDirectory()) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("ResourceFileIndexSelector.Building_indexes_from_resource_found_under_folder_._4", (Object)filepath));
        } else if (this.selectedFile.isFile()) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("ResourceFileIndexSelector.Building_indexes_from_resource_at_._5", (Object)filepath));
        } else {
            throw new ModelerCoreException(ModelerCore.Util.getString("ResourceFileIndexSelector.The_specified_file_cannot_be_processed_by_the_ResourceFileIndexSelector_6", (Object)filepath));
        }
    }

    public Index[] getIndexes() throws IOException {
        if (this.indexes == null || this.indexes.length == 0) {
            this.indexes = this.buildIndexes(this.selectedFile);
        }
        return this.indexes;
    }

    protected Index[] buildIndexes(File f) throws IOException {
        File[] modelFiles = this.loadModelFiles(f);
        Resource[] models = EMPTY_RESOURCE_ARRAY;
        try {
            models = this.loadResources(modelFiles);
        }
        catch (Throwable e) {
            ModelerCore.Util.log(4, e, ModelerCore.Util.getString("ResourceFileIndexSelector.Error_loading_resources_for_7", (Object)f));
        }
        Index[] newIndexes = EMPTY_INDEX_ARRAY;
        try {
            newIndexes = this.indexResources(models);
        }
        catch (Throwable e) {
            ModelerCore.Util.log(4, e, ModelerCore.Util.getString("ResourceFileIndexSelector.Error_building_indexes_for_resources_in_8", (Object)f));
        }
        return newIndexes;
    }

    protected Index[] indexResources(Resource[] models) throws CoreException {
        ArrayList<Index> tmp = new ArrayList<Index>();
        File indexDirectory = new File(this.getIndexDirectoryPath());
        int i = 0;
        while (i < models.length) {
            EmfResource resource = (EmfResource)models[i];
            if (resource != null) {
                Index theIndex;
                String indexFileName = resource.getURI().lastSegment();
                String extension = resource.getURI().fileExtension();
                if (extension != null) {
                    int endIndex = indexFileName.indexOf(extension) - 1;
                    indexFileName = indexFileName.substring(0, endIndex);
                }
                indexFileName = String.valueOf(indexFileName) + "." + "INDEX";
                File indexFilePath = new File(String.valueOf(indexDirectory.getAbsolutePath()) + File.separator + indexFileName);
                if (indexFilePath.exists()) {
                    indexFilePath.delete();
                }
                String resourcePath = resource.getURI().toFileString();
                IndexUtil.indexResource((Resource)resource, resourcePath, this.getIndexDirectoryPath(), indexFileName);
                File indexFile = new File(indexDirectory, indexFileName);
                if (this.isIndexFile(indexFile) && (theIndex = IndexUtil.getIndexFile(indexFile.getName(), indexFile.getAbsolutePath(), resource.getURI().lastSegment())) != null) {
                    tmp.add(theIndex);
                }
            }
            ++i;
        }
        Index[] result = new Index[tmp.size()];
        tmp.toArray(result);
        return result;
    }

    protected Resource[] loadResources(File[] modelFiles) throws CoreException {
        ArrayList<Resource> tmp = new ArrayList<Resource>();
        String tempContainerName = String.valueOf(DateUtil.getCurrentDateAsString()) + "_Container";
        Container container = this.createContainer(tempContainerName);
        int i = 0;
        while (i < modelFiles.length) {
            File modelFile = modelFiles[i];
            Resource resource = this.loadResource(container, modelFile);
            if (resource != null && resource instanceof EmfResource) {
                tmp.add(resource);
            }
            ++i;
        }
        Resource[] result = new Resource[tmp.size()];
        tmp.toArray(result);
        return result;
    }

    protected Resource loadResource(Container container, File modelFile) {
        URI uri = URI.createFileURI((String)modelFile.getAbsolutePath());
        Resource resource = container.getResource(uri, true);
        return resource;
    }

    protected Container createContainer(String name) throws CoreException {
        return ModelerCore.createContainer(name);
    }

    protected File[] loadModelFiles(File f) throws IOException {
        File[] modelFiles = EMPTY_FILE_ARRAY;
        modelFiles = FileUtils.isArchiveFileName((String)f.getName()) ? this.loadModelsFromZip(f) : (f.isDirectory() ? this.loadModelsFromFolder(f) : this.loadModelsFromFile(f));
        return modelFiles;
    }

    protected File[] loadModelsFromFile(File file) {
        File[] result = EMPTY_FILE_ARRAY;
        if (ModelFileUtil.isModelFile((File)file)) {
            result = new File[]{file};
        }
        return result;
    }

    protected File[] loadModelsFromFolder(File folder) {
        ArrayList<File> tmp = new ArrayList<File>();
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length) {
            if (ModelFileUtil.isModelFile((File)files[i])) {
                tmp.add(files[i]);
            }
            ++i;
        }
        File[] result = new File[tmp.size()];
        tmp.toArray(result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File[] loadModelsFromZip(File zip) throws IOException {
        File[] fileArray;
        ZipFile zipFile = null;
        try {
            ZipEntry entry;
            zipFile = new ZipFile(zip);
            ArrayList<File> tmp = new ArrayList<File>();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements() && (entry = entries.nextElement()) != null) {
                byte[] buffer;
                Path zipEntryPath = new Path(entry.getName());
                String entryName = zipEntryPath.lastSegment();
                InputStream inputStream = zipFile.getInputStream(entry);
                int length = (int)entry.getSize();
                if (length >= 0) {
                    int n;
                    buffer = new byte[length];
                    int offset = 0;
                    do {
                        n = inputStream.read(buffer, offset, length);
                        offset += n;
                    } while ((length -= n) > 0);
                } else {
                    int n;
                    buffer = new byte[1024];
                    while ((n = inputStream.read(buffer, 0, 1024)) >= 0) {
                    }
                }
                File indexDirectory = new File(this.getIndexDirectoryPath());
                if (!indexDirectory.exists()) {
                    indexDirectory.mkdir();
                }
                File entryFile = new File(String.valueOf(indexDirectory.getAbsolutePath()) + File.separator + entryName);
                entryFile.createNewFile();
                entryFile.deleteOnExit();
                FileOutputStream outputStream = new FileOutputStream(entryFile);
                outputStream.write(buffer);
                outputStream.flush();
                outputStream.close();
                if (!ModelFileUtil.isModelFile((File)entryFile)) continue;
                tmp.add(entryFile);
            }
            File[] result = new File[tmp.size()];
            tmp.toArray(result);
            fileArray = result;
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile == null) throw throwable;
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (zipFile == null) return fileArray;
            zipFile.close();
            return fileArray;
        }
        catch (IOException iOException) {}
        return fileArray;
    }

    protected boolean isIndexFile(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        return fileName.endsWith("INDEX");
    }

    protected boolean isIndexFile(File file) {
        if (file != null && file.isFile() && file.exists()) {
            return this.isIndexFile(file.getName());
        }
        return false;
    }

    protected String getIndexDirectoryPath() {
        if (this.indexDirectoryPath == null) {
            this.indexDirectoryPath = TEMP_DIR;
        }
        return this.indexDirectoryPath;
    }

    protected void setIndexDirectoryPath(String path) {
        this.indexDirectoryPath = path;
    }
}

