/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.index;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.index.AbstractIndexSelector;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexUtil;

public class TargetLocationIndexSelector
extends AbstractIndexSelector {
    public static final Index[] EMPTY_INDEX_ARRAY = new Index[0];
    private final String indexLocation;
    private Index[] indexes;

    public TargetLocationIndexSelector(String indexLocation) {
        CoreArgCheck.isNotNull((Object)indexLocation);
        this.indexLocation = indexLocation;
    }

    public Index[] getIndexes() throws IOException {
        if (this.indexes == null) {
            File indexDir = new File(this.indexLocation);
            FilenameFilter fileFilter = this.getIndexFileFilter();
            File[] files = null;
            files = fileFilter != null ? indexDir.listFiles(fileFilter) : indexDir.listFiles();
            ArrayList<Index> tmp = new ArrayList<Index>();
            int i = 0;
            while (i < files.length) {
                File indexFile = files[i];
                if (IndexUtil.indexFileExists(indexFile)) {
                    tmp.add(new Index(indexFile.getAbsolutePath(), true));
                }
                ++i;
            }
            this.indexes = new Index[tmp.size()];
            tmp.toArray(this.indexes);
        }
        return this.indexes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("TargetLocationIndexSelector [");
        Index[] indexes = EMPTY_INDEX_ARRAY;
        try {
            indexes = this.getIndexes();
        }
        catch (IOException iOException) {}
        int i = 0;
        while (i < indexes.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(indexes[i].getIndexFile());
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    protected void setIndexes(Index[] indexes) {
        this.indexes = indexes;
    }

    protected FilenameFilter getIndexFileFilter() {
        return null;
    }
}

