/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.loading;

import java.util.Properties;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.loading.IManagedLoading;
import org.teiid.designer.runtime.spi.ITeiidServerManager;

public class ComponentLoadingManager {
    private static ComponentLoadingManager instance;

    public static ComponentLoadingManager getInstance() {
        if (instance == null) {
            instance = new ComponentLoadingManager();
        }
        return instance;
    }

    public void manageLoading(IManagedLoading component, Properties args) {
        if (ModelerCore.getTeiidServerManager().isStarted()) {
            component.manageLoad(args);
            return;
        }
        LoadingThread thread = new LoadingThread(component, args);
        thread.start();
    }

    public void manageLoading(IManagedLoading component) {
        this.manageLoading(component, new Properties());
    }

    private class LoadingThread
    extends Thread {
        private final IManagedLoading component;
        private final Properties args;

        public LoadingThread(IManagedLoading component, Properties args) {
            super(String.valueOf(component.getClass().getSimpleName()) + "." + LoadingThread.class.getSimpleName());
            this.component = component;
            this.args = args;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            ITeiidServerManager serverManager = ModelerCore.getTeiidServerManager();
            while (!serverManager.isStarted()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    ModelerCore.Util.log((Throwable)ex);
                }
            }
            this.component.manageLoad(this.args);
        }
    }
}

