/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.MetamodelEntityImpl;
import org.teiid.designer.core.metamodel.MetamodelRegistry;
import org.teiid.designer.core.metamodel.aspect.DependencyAspect;
import org.teiid.designer.core.metamodel.aspect.FeatureConstraintAspect;
import org.teiid.designer.core.metamodel.aspect.ImportsAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspectFactory;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.ValidationAspect;
import org.teiid.designer.core.metamodel.aspect.relationship.RelationshipMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlDiagramAspect;

public class MetamodelAspectManager {
    private static final Map ASPECT_INTERFACE_TO_EXTENSION_ID = new HashMap(7);
    private MetamodelRegistry registry;
    private Map metamodelEntityMap;
    private ComposedAdapterFactory composedAdapterFactory;

    static {
        ASPECT_INTERFACE_TO_EXTENSION_ID.put(SqlAspect.class, "sqlAspect");
        ASPECT_INTERFACE_TO_EXTENSION_ID.put(UmlDiagramAspect.class, "umlDiagramAspect");
        ASPECT_INTERFACE_TO_EXTENSION_ID.put(ValidationAspect.class, "validationAspect");
        ASPECT_INTERFACE_TO_EXTENSION_ID.put(DependencyAspect.class, "dependencyAspect");
        ASPECT_INTERFACE_TO_EXTENSION_ID.put(FeatureConstraintAspect.class, "featureConstraintAspect");
        ASPECT_INTERFACE_TO_EXTENSION_ID.put(ImportsAspect.class, "importAspect");
        ASPECT_INTERFACE_TO_EXTENSION_ID.put(RelationshipMetamodelAspect.class, "relationshipAspect");
    }

    public MetamodelAspectManager(MetamodelRegistry theRegistry) {
        CoreArgCheck.isNotNull((Object)theRegistry);
        this.registry = theRegistry;
        this.metamodelEntityMap = new HashMap();
        this.initializeRegistry(this.registry);
    }

    public AdapterFactory getAdapterFactory() {
        if (this.composedAdapterFactory == null) {
            this.composedAdapterFactory = new MetamodelComposedAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            MetamodelDescriptor[] descriptors = this.getRegistry().getMetamodelDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                MetamodelDescriptor d = descriptors[i];
                this.addAdapterFactories(this.composedAdapterFactory, d);
                ++i;
            }
        }
        return this.composedAdapterFactory;
    }

    public MetamodelAspect getMetamodelAspect(EClass eClass, Class type) {
        CoreArgCheck.isNotNull((Object)eClass);
        CoreArgCheck.isNotNull((Object)type);
        MetamodelEntity entity = this.getMetamodelEntity(eClass);
        if (entity != null) {
            String extensionID = (String)ASPECT_INTERFACE_TO_EXTENSION_ID.get(type);
            if (extensionID == null) {
                String msg = ModelerCore.Util.getString("MetamodelAspectManager.Class_does_not_match_any_metamodel_aspect_ID", (Object)type.getName());
                throw new IllegalArgumentException(msg);
            }
            return entity.getMetamodelAspect(extensionID);
        }
        return null;
    }

    public MetamodelAspect getMetamodelAspect(EClass eClass, String extensionID) {
        CoreArgCheck.isNotNull((Object)eClass);
        CoreArgCheck.isNotNull((Object)extensionID);
        CoreArgCheck.isNotZeroLength((String)extensionID);
        MetamodelEntity entity = this.getMetamodelEntity(eClass);
        if (entity != null) {
            return entity.getMetamodelAspect(extensionID);
        }
        return null;
    }

    protected void initializeRegistry(MetamodelRegistry registry) {
        CoreArgCheck.isNotNull((Object)registry);
        try {
            MetamodelDescriptor[] descriptors = this.getRegistry().getMetamodelDescriptors();
            int i = 0;
            while (i != descriptors.length) {
                MetamodelDescriptor d = descriptors[i];
                registry.register(d);
                URI nsUri = registry.getURI(d.getNamespaceURI());
                CoreArgCheck.isNotNull((Object)nsUri);
                EPackage ePkg = registry.getEPackage(nsUri);
                CoreArgCheck.isNotNull((Object)ePkg);
                ++i;
            }
        }
        catch (Throwable e) {
            ModelerCore.Util.log(e);
        }
    }

    protected void addAdapterFactories(ComposedAdapterFactory composedFactory, MetamodelDescriptor descriptor) {
        CoreArgCheck.isNotNull((Object)composedFactory);
        CoreArgCheck.isNotNull((Object)descriptor);
        AdapterFactory[] factories = descriptor.getAdapterFactories();
        int i = 0;
        while (i < factories.length) {
            AdapterFactory factory = factories[i];
            if (factory != null) {
                composedFactory.addAdapterFactory(factory);
            }
            ++i;
        }
    }

    protected MetamodelAspectFactory[] getAspectFactories(EClass eClass) {
        CoreArgCheck.isNotNull((Object)eClass);
        URI metamodelURI = this.getMetamodelURI(eClass);
        this.checkIsRegisteredMetamodel(metamodelURI);
        MetamodelDescriptor d = this.getRegistry().getMetamodelDescriptor(metamodelURI);
        return d.getAspectFactories();
    }

    protected MetamodelEntity getMetamodelEntity(EClass eClass) {
        CoreArgCheck.isNotNull((Object)eClass);
        if (!this.isSupportedMetamodel(eClass)) {
            return null;
        }
        URI metamodelURI = this.getMetamodelURI(eClass);
        this.checkIsRegisteredMetamodel(metamodelURI);
        if (!this.getMetamodelEntityMap().containsKey(eClass)) {
            this.getMetamodelEntityMap().put(eClass, this.createMetamodelEntity(eClass));
        }
        return (MetamodelEntity)this.getMetamodelEntityMap().get(eClass);
    }

    protected MetamodelEntity createMetamodelEntity(EClass eClass) {
        CoreArgCheck.isNotNull((Object)eClass);
        URI metamodelURI = this.getMetamodelURI(eClass);
        MetamodelEntityImpl entity = new MetamodelEntityImpl(metamodelURI, eClass);
        MetamodelAspectFactory[] factories = this.getAspectFactories(eClass);
        int i = 0;
        while (i < factories.length) {
            MetamodelAspectFactory factory = factories[i];
            try {
                MetamodelAspect aspect = factory.create((EClassifier)eClass, entity);
                if (aspect != null) {
                    entity.addMetamodelAspect(aspect.getID(), aspect);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ++i;
        }
        return entity;
    }

    protected URI getMetamodelURI(EClass eClass) {
        CoreArgCheck.isNotNull((Object)eClass);
        return URI.createURI((String)eClass.getEPackage().getNsURI());
    }

    protected boolean isSupportedMetamodel(EClass eClass) {
        URI metamodelURI;
        CoreArgCheck.isNotNull((Object)eClass);
        Resource resource = eClass.eResource();
        return resource != null && (metamodelURI = resource.getURI()) != null && this.getRegistry().containsURI(metamodelURI);
    }

    protected void checkIsRegisteredMetamodel(URI metamodelURI) {
        if (!this.getRegistry().containsURI(metamodelURI)) {
            String msg = ModelerCore.Util.getString("MetamodelAspectManager.Metamodel_does_not_exist_in_registry", (Object)metamodelURI);
            throw new IllegalArgumentException(msg);
        }
    }

    protected MetamodelRegistry getRegistry() {
        return this.registry;
    }

    protected Map getMetamodelEntityMap() {
        return this.metamodelEntityMap;
    }

    protected static class MetamodelComposedAdapterFactory
    extends ComposedAdapterFactory {
        private static final String UML_ADAPTER_FACTORY_CLASS_NAME = "org.teiid.designer.metamodels.uml2.provider.Uml2ItemProviderAdapterFactory";
        private EcoreItemProviderAdapterFactory ecoreAdapter;

        public MetamodelComposedAdapterFactory(AdapterFactory delegateFactory) {
            super(delegateFactory);
        }

        public AdapterFactory getFactoryForTypes(Collection types) {
            AdapterFactory result = super.getFactoryForTypes(types);
            if (result != null) {
                return result;
            }
            return super.getFactoryForTypes(types);
        }

        public Adapter adapt(Notifier target, Object type) {
            Adapter adapter = super.adapt(target, type);
            if (adapter == null && this.ecoreAdapter != null) {
                adapter = this.ecoreAdapter.adapt(target, type);
            }
            return adapter;
        }

        public void addAdapterFactory(AdapterFactory adapterFactory) {
            if (adapterFactory == null) {
                return;
            }
            AdapterFactory ecoreAdapterFactory = null;
            AdapterFactory umlAdapterFactory = null;
            ArrayList tempAdapterFactories = new ArrayList(this.adapterFactories);
            for (AdapterFactory af : tempAdapterFactories) {
                if (af != null && af.getClass().equals(adapterFactory.getClass())) {
                    return;
                }
                if (UML_ADAPTER_FACTORY_CLASS_NAME.equals(af.getClass().getName())) {
                    umlAdapterFactory = af;
                    continue;
                }
                if (!af.getClass().equals(EcoreItemProviderAdapterFactory.class)) continue;
                ecoreAdapterFactory = af;
            }
            super.addAdapterFactory(adapterFactory);
            if (umlAdapterFactory != null) {
                this.adapterFactories.remove(umlAdapterFactory);
                super.addAdapterFactory(umlAdapterFactory);
            }
            if (ecoreAdapterFactory != null) {
                this.adapterFactories.remove(ecoreAdapterFactory);
                super.addAdapterFactory(ecoreAdapterFactory);
                this.ecoreAdapter = (EcoreItemProviderAdapterFactory)ecoreAdapterFactory;
            }
        }
    }
}

