/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EPackage;
import org.osgi.framework.Bundle;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelInitializer;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.metamodel.MetamodelRootClassDescriptor;
import org.teiid.designer.core.metamodel.aspect.DependencyAspect;
import org.teiid.designer.core.metamodel.aspect.FeatureConstraintAspect;
import org.teiid.designer.core.metamodel.aspect.ImportsAspect;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspectFactory;
import org.teiid.designer.core.metamodel.aspect.ValidationAspect;
import org.teiid.designer.core.metamodel.aspect.relationship.RelationshipMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlDiagramAspect;
import org.teiid.designer.metamodels.core.ModelType;

public class MetamodelDescriptorImpl
implements MetamodelDescriptor {
    private static final ModelType[] EMPTY_MODEL_TYPE_ARRAY = new ModelType[0];
    private static final MetamodelRootClassDescriptor[] EMPTY_ROOT_CLASS_DESCRIPTOR_ARRAY = new MetamodelRootClassDescriptor[0];
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static final boolean IS_PRIMARY_DEFAULT_VALUE = true;
    private static final boolean SUPPORTS_NEW_MODEL_DEFAULT_VALUE = true;
    private static final boolean SUPPORTS_DIAGRAMS_DEFAULT_VALUE = false;
    private static final boolean SUPPORTS_EXTENSION_DEFAULT_VALUE = false;
    private static final Map EXTENSION_ID_TO_ASPECT_INTERFACE_MAP = new HashMap(7);
    private String extensionID;
    private String displayName;
    private String namespaceURI;
    private Properties properties;
    private List alternateNamespaceURIs;
    private List allowableModelTypes;
    private String fileExtension;
    private DescriptorClassLoader ePackageClassLoader;
    private List adapterFactories;
    private List adapterFactoryDescriptorClassLoaders;
    private Map aspectFactoryMap;
    private Map aspectFactoryDescriptorClassLoaderMap;
    private List rootClassDescriptors;
    private final Map modelInitializerDescriptorClassLoadersByName;
    private final Map modelInitializerDescriptionsByName;
    private final List modelInitializerNames;
    private final List readOnlyModelInitializerNames;

    static {
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("sqlAspect", SqlAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("umlDiagramAspect", UmlDiagramAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("validationAspect", ValidationAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("dependencyAspect", DependencyAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("featureConstraintAspect", FeatureConstraintAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("importAspect", ImportsAspect.class);
        EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.put("relationshipAspect", RelationshipMetamodelAspect.class);
    }

    public MetamodelDescriptorImpl(String theNamespaceURI, String ePackageClassName, Bundle bundle) {
        CoreArgCheck.isNotZeroLength((String)theNamespaceURI);
        CoreArgCheck.isNotZeroLength((String)ePackageClassName);
        CoreArgCheck.isNotNull((Object)bundle);
        this.namespaceURI = theNamespaceURI;
        this.ePackageClassLoader = new DescriptorClassLoader(ePackageClassName, bundle);
        this.extensionID = null;
        this.displayName = null;
        this.fileExtension = null;
        this.properties = new Properties();
        this.alternateNamespaceURIs = new ArrayList(11);
        this.allowableModelTypes = new ArrayList(11);
        this.adapterFactoryDescriptorClassLoaders = new ArrayList(11);
        this.adapterFactories = new ArrayList(11);
        this.aspectFactoryDescriptorClassLoaderMap = new HashMap(11);
        this.aspectFactoryMap = new HashMap(11);
        this.rootClassDescriptors = new ArrayList(11);
        this.modelInitializerDescriptorClassLoadersByName = new HashMap();
        this.modelInitializerDescriptionsByName = new HashMap();
        this.modelInitializerNames = new ArrayList();
        this.readOnlyModelInitializerNames = Collections.unmodifiableList(this.modelInitializerNames);
    }

    @Override
    public String getExtensionID() {
        return this.extensionID;
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getName();
    }

    @Override
    public String getName() {
        if (this.getEPackage() != null) {
            return this.getEPackage().getName();
        }
        return null;
    }

    @Override
    public String getNamespacePrefix() {
        if (this.getEPackage() != null) {
            return this.getEPackage().getNsPrefix();
        }
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public String getFileExtension() {
        if (this.fileExtension == null) {
            this.fileExtension = ".xmi";
        }
        return this.fileExtension;
    }

    @Override
    public EPackage getEPackage() {
        return this.getPackageForURI(this.getNamespaceURI());
    }

    @Override
    public ModelType[] getAllowableModelTypes() {
        if (this.allowableModelTypes == null || this.allowableModelTypes.isEmpty()) {
            return EMPTY_MODEL_TYPE_ARRAY;
        }
        ModelType[] result = new ModelType[this.allowableModelTypes.size()];
        return this.allowableModelTypes.toArray(result);
    }

    @Override
    public String[] getAlternateNamespaceURIs() {
        if (this.alternateNamespaceURIs == null || this.alternateNamespaceURIs.isEmpty()) {
            return CoreStringUtil.Constants.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[this.alternateNamespaceURIs.size()];
        return this.alternateNamespaceURIs.toArray(result);
    }

    @Override
    public boolean isPrimary() {
        String value;
        boolean isPrimary = true;
        if (this.properties != null && (value = (String)this.properties.get("participatoryOnly")) != null && value.equalsIgnoreCase(TRUE)) {
            isPrimary = false;
        }
        return isPrimary;
    }

    @Override
    public boolean supportsDiagrams() {
        String value;
        boolean supportsDiagrams = false;
        if (this.properties != null && (value = (String)this.properties.get("supportsDiagrams")) != null) {
            supportsDiagrams = Boolean.valueOf(value);
        }
        return supportsDiagrams;
    }

    @Override
    public boolean supportsExtension() {
        String value;
        boolean supportsExtension = false;
        if (this.properties != null && (value = (String)this.properties.get("supportsExtension")) != null) {
            supportsExtension = Boolean.valueOf(value);
        }
        return supportsExtension;
    }

    @Override
    public boolean supportsNewModel() {
        String value;
        boolean supportsNewModel = true;
        if (this.properties != null && (value = (String)this.properties.get("createAsNewModel")) != null) {
            supportsNewModel = Boolean.valueOf(value);
        }
        return supportsNewModel;
    }

    @Override
    public ModelInitializer getModelInitializer(String name) {
        Object instance;
        DescriptorClassLoader loader = (DescriptorClassLoader)this.modelInitializerDescriptorClassLoadersByName.get(name);
        if (loader != null && (instance = loader.getClassInstance()) instanceof ModelInitializer) {
            return (ModelInitializer)instance;
        }
        return null;
    }

    @Override
    public String getModelInitializerDescription(String name) {
        return (String)this.modelInitializerDescriptionsByName.get(name);
    }

    @Override
    public List getModelInitializerNames() {
        return this.readOnlyModelInitializerNames;
    }

    @Override
    public MetamodelRootClassDescriptor[] getRootClassDescriptors() {
        if (this.rootClassDescriptors == null || this.rootClassDescriptors.isEmpty()) {
            return EMPTY_ROOT_CLASS_DESCRIPTOR_ARRAY;
        }
        MetamodelRootClassDescriptor[] result = new MetamodelRootClassDescriptor[this.rootClassDescriptors.size()];
        return this.rootClassDescriptors.toArray(result);
    }

    @Override
    public AdapterFactory[] getAdapterFactories() {
        if (this.adapterFactories.isEmpty()) {
            this.initializeAdapterFactoryList();
        }
        AdapterFactory[] result = new AdapterFactory[this.adapterFactories.size()];
        return this.adapterFactories.toArray(result);
    }

    @Override
    public MetamodelAspectFactory[] getAspectFactories() {
        if (this.aspectFactoryMap.isEmpty()) {
            this.initializeAspectFactoryMap();
        }
        MetamodelAspectFactory[] result = new MetamodelAspectFactory[this.aspectFactoryMap.values().size()];
        return this.aspectFactoryMap.values().toArray(result);
    }

    @Override
    public MetamodelAspectFactory getAspectFactory(Class theType) {
        CoreArgCheck.isNotNull((Object)theType);
        if (this.aspectFactoryMap.isEmpty()) {
            this.initializeAspectFactoryMap();
        }
        return (MetamodelAspectFactory)this.aspectFactoryMap.get(theType);
    }

    @Override
    public MetamodelAspectFactory getAspectFactory(String extensionID) {
        CoreArgCheck.isNotZeroLength((String)extensionID);
        Class type = (Class)EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.get(extensionID);
        if (type == null) {
            String msg = ModelerCore.Util.getString("MetamodelDescriptorImpl.Extension_ID_does_not_match_any_metamodel_aspect_class", (Object)extensionID);
            throw new IllegalArgumentException(msg);
        }
        return this.getAspectFactory(type);
    }

    public void setExtensionID(String theExtensionID) {
        this.extensionID = theExtensionID;
    }

    public void setDisplayName(String theDisplayName) {
        this.displayName = theDisplayName;
    }

    public void setFileExtension(String string) {
        CoreArgCheck.isNotZeroLength((String)string);
        String extension = string.trim();
        this.fileExtension = extension.charAt(0) == '.' ? extension : "." + extension;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        CoreArgCheck.isNotNull((Object)properties);
        this.properties = properties;
        this.addDefaultPropertyValues(this.properties);
    }

    public void addAlternateNamespaceURI(String alternateNamespaceURI) {
        CoreArgCheck.isNotZeroLength((String)alternateNamespaceURI);
        if (!this.alternateNamespaceURIs.contains(alternateNamespaceURI)) {
            this.alternateNamespaceURIs.add(alternateNamespaceURI);
        }
    }

    public void addAllowableModelType(String modelTypeName) {
        CoreArgCheck.isNotZeroLength((String)modelTypeName);
        ModelType type = ModelType.get((String)modelTypeName);
        if (type != null && !this.allowableModelTypes.contains(type)) {
            this.allowableModelTypes.add(type);
        }
    }

    public void addRootClassDescriptor(MetamodelRootClassDescriptor descriptor) {
        CoreArgCheck.isNotNull((Object)descriptor);
        for (MetamodelRootClassDescriptor d : this.rootClassDescriptors) {
            if (descriptor.getClassName() == null || !descriptor.getClassName().equals(d.getClassName())) continue;
            return;
        }
        this.rootClassDescriptors.add(descriptor);
    }

    public void addAdapterFactoryBundle(String className, Bundle bundle) {
        DescriptorClassLoader newDescriptor = new DescriptorClassLoader(className, bundle);
        if (!this.adapterFactoryDescriptorClassLoaders.contains(newDescriptor)) {
            this.adapterFactoryDescriptorClassLoaders.add(newDescriptor);
        }
    }

    public void addAspectFactoryBundle(String extensionPointID, String className, Bundle bundle) {
        CoreArgCheck.isNotZeroLength((String)extensionPointID);
        String extensionID = CoreStringUtil.getLastToken((String)extensionPointID, (String)".");
        Class type = (Class)EXTENSION_ID_TO_ASPECT_INTERFACE_MAP.get(extensionID);
        if (type == null) {
            String msg = ModelerCore.Util.getString("MetamodelDescriptorImpl.Extension_ID_does_not_match_any_metamodel_aspect_class", (Object)extensionID);
            throw new IllegalArgumentException(msg);
        }
        if (this.aspectFactoryDescriptorClassLoaderMap.containsKey(type)) {
            this.aspectFactoryDescriptorClassLoaderMap.remove(type);
        }
        DescriptorClassLoader newDescriptor = new DescriptorClassLoader(className, bundle);
        this.aspectFactoryDescriptorClassLoaderMap.put(type, newDescriptor);
    }

    public void addModelInitializer(String name, String desc, String className, Bundle bundle) {
        DescriptorClassLoader loader = new DescriptorClassLoader(className, bundle);
        try {
            this.modelInitializerDescriptorClassLoadersByName.put(name, loader);
            this.modelInitializerDescriptionsByName.put(name, desc);
            this.modelInitializerNames.add(name);
        }
        catch (Throwable throwable) {
            try {
                this.modelInitializerDescriptorClassLoadersByName.remove(name);
                this.modelInitializerDescriptionsByName.remove(name);
            }
            catch (RuntimeException e1) {
                ModelerCore.Util.log((Throwable)e1);
            }
        }
    }

    public void dispose() {
        this.properties = null;
        this.alternateNamespaceURIs.clear();
        this.allowableModelTypes.clear();
        this.ePackageClassLoader = null;
        this.adapterFactories.clear();
        this.adapterFactoryDescriptorClassLoaders.clear();
        this.aspectFactoryMap.clear();
        this.aspectFactoryDescriptorClassLoaderMap.clear();
        this.rootClassDescriptors.clear();
        this.modelInitializerDescriptorClassLoadersByName.clear();
        this.modelInitializerDescriptionsByName.clear();
        this.modelInitializerNames.clear();
    }

    protected EPackage.Registry getEPackageRegistry() {
        return EPackage.Registry.INSTANCE;
    }

    protected EPackage getPackageForURI(String uriString) {
        Class javaClass;
        if (CoreStringUtil.isEmpty((String)uriString)) {
            return null;
        }
        EPackage ePackage = this.getEPackageRegistry().getEPackage(uriString);
        if (ePackage != null && ePackage.eIsProxy()) {
            this.getEPackageRegistry().remove((Object)uriString);
            ePackage = null;
        }
        if (ePackage == null && this.ePackageClassLoader != null && (javaClass = this.ePackageClassLoader.getLoadedClass()) != null) {
            if (javaClass.isInterface()) {
                try {
                    Field field = javaClass.getField("eINSTANCE");
                    ePackage = (EPackage)field.get(null);
                }
                catch (Exception e) {
                    throw new TeiidDesignerRuntimeException((Throwable)e);
                }
            }
            try {
                Class<?>[] interfaces = javaClass.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    Field field = interfaces[i].getField("eINSTANCE");
                    ePackage = (EPackage)field.get(null);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new TeiidDesignerRuntimeException((Throwable)e);
            }
            if (ePackage != null) {
                this.getEPackageRegistry().put((Object)uriString, (Object)ePackage);
                if (!uriString.equals(ePackage.getNsURI())) {
                    this.getEPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
                }
            }
        }
        if (ePackage != null && this.alternateNamespaceURIs != null && !this.alternateNamespaceURIs.isEmpty()) {
            EPackage.Registry ePkgRegistry = this.getEPackageRegistry();
            for (String nsUri : this.alternateNamespaceURIs) {
                if (ePkgRegistry.getEPackage(nsUri) != null) continue;
                ePkgRegistry.put((Object)nsUri, (Object)ePackage);
            }
        }
        return ePackage;
    }

    protected void addDefaultPropertyValues(Properties props) {
        boolean participatoryOnly;
        String key = "participatoryOnly";
        String val = props.getProperty(key);
        if (val == null) {
            participatoryOnly = false;
            props.setProperty(key, Boolean.toString(false));
        } else {
            participatoryOnly = Boolean.valueOf(val);
        }
        key = "supportsDiagrams";
        if (props.getProperty(key) == null) {
            props.setProperty(key, Boolean.toString(false));
        }
        if (props.getProperty(key = "supportsExtension") == null) {
            props.setProperty(key, Boolean.toString(false));
        }
        key = "createAsNewModel";
        if (participatoryOnly) {
            props.setProperty(key, FALSE);
        } else if (props.getProperty(key) == null) {
            props.setProperty(key, Boolean.toString(true));
        }
    }

    protected void initializeAdapterFactoryList() {
        if (this.adapterFactoryDescriptorClassLoaders != null && !this.adapterFactoryDescriptorClassLoaders.isEmpty()) {
            for (DescriptorClassLoader d : this.adapterFactoryDescriptorClassLoaders) {
                AdapterFactory factory = (AdapterFactory)d.getClassInstance();
                if (factory == null || this.adapterFactories.contains(factory)) continue;
                this.adapterFactories.add(factory);
            }
        }
    }

    protected void initializeAspectFactoryMap() {
        if (this.aspectFactoryDescriptorClassLoaderMap != null && !this.aspectFactoryDescriptorClassLoaderMap.isEmpty()) {
            for (Map.Entry entry : this.aspectFactoryDescriptorClassLoaderMap.entrySet()) {
                Class type = (Class)entry.getKey();
                DescriptorClassLoader d = (DescriptorClassLoader)entry.getValue();
                MetamodelAspectFactory factory = (MetamodelAspectFactory)d.getClassInstance();
                if (factory == null) continue;
                this.aspectFactoryMap.put(type, factory);
            }
        }
    }

    private class DescriptorClassLoader {
        private final String className;
        private final Bundle bundle;
        private boolean loadClassFailure;
        private boolean newInstanceFailure;
        private Class loadedClass;
        private Object classInstance;

        public DescriptorClassLoader(String className, Bundle bundle) {
            CoreArgCheck.isNotZeroLength((String)className);
            CoreArgCheck.isNotNull((Object)bundle);
            this.className = className;
            this.bundle = bundle;
            this.loadClassFailure = false;
            this.newInstanceFailure = false;
            this.loadedClass = null;
            this.classInstance = null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescriptorClassLoader)) {
                return false;
            }
            DescriptorClassLoader that = (DescriptorClassLoader)obj;
            if (this.className.equals(that.className) && this.bundle.equals(that.bundle)) {
                return true;
            }
            return super.equals(obj);
        }

        public Class getLoadedClass() {
            if (!this.loadClassFailure && this.loadedClass == null) {
                try {
                    this.loadedClass = this.bundle.loadClass(this.className);
                    this.loadClassFailure = false;
                }
                catch (Throwable throwable) {
                    String msg = ModelerCore.Util.getString("MetamodelDescriptorImpl.Unable_to_load_class_using_bundle", new Object[]{this.className, this.bundle});
                    ModelerCore.Util.log(4, msg);
                    this.loadedClass = null;
                    this.loadClassFailure = true;
                }
            }
            return this.loadedClass;
        }

        public Object getClassInstance() {
            if (!this.newInstanceFailure && this.classInstance == null && this.getLoadedClass() != null) {
                try {
                    this.classInstance = this.getLoadedClass().newInstance();
                    this.newInstanceFailure = false;
                }
                catch (InstantiationException e) {
                    String msg = ModelerCore.Util.getString("MetamodelDescriptorImpl.Unable_to_create_instance", (Object)this.className);
                    ModelerCore.Util.log(4, (Throwable)e, msg);
                    this.classInstance = null;
                    this.newInstanceFailure = true;
                }
                catch (IllegalAccessException e) {
                    String msg = ModelerCore.Util.getString("MetamodelDescriptorImpl.Error_creating_instance", (Object)this.className);
                    ModelerCore.Util.log(4, (Throwable)e, msg);
                    this.classInstance = null;
                    this.newInstanceFailure = true;
                }
            }
            return this.classInstance;
        }

        public String toString() {
            Object[] params = new Object[]{this.className, this.bundle, new Boolean(this.loadedClass != null)};
            return ModelerCore.Util.getString("MetamodelDescriptorImpl.descriptor_info", params);
        }
    }
}

