/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.Multiplicity;

final class RangeMultiplicity
extends Multiplicity {
    private static final long serialVersionUID = 1L;
    private List intervals = new ArrayList();
    private Multiplicity first;
    private Multiplicity last;

    RangeMultiplicity(List intervals, boolean isOrdered, boolean isUnique) {
        super(isOrdered, isUnique);
        this.intervals = intervals;
        if (this.intervals == null || this.intervals.size() == 0) {
            throw new IllegalArgumentException(ModelerCore.Util.getString("Multiplicity.Unable_to_create_a_RangeMultiplicity_with_zero-length_or_null_list_of_intervals", new Object[0]));
        }
        this.first = (Multiplicity)this.intervals.get(0);
        this.last = (Multiplicity)this.intervals.get(this.intervals.size() - 1);
    }

    public List getIntervals() {
        return this.intervals;
    }

    @Override
    public int getMaximum() {
        return this.last.getMaximum();
    }

    @Override
    public int getMinimum() {
        return this.first.getMinimum();
    }

    @Override
    public boolean isUnlimited() {
        return this.last.isUnlimited();
    }

    @Override
    public boolean isIncluded(int cardinality) {
        boolean result = false;
        for (Multiplicity m : this.intervals) {
            if (!m.isIncluded(cardinality)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.intervals.iterator();
        if (iter.hasNext()) {
            sb.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            sb.append(',');
            sb.append(iter.next().toString());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Object obj) {
        CoreArgCheck.isNotNull((Object)obj);
        Multiplicity that = (Multiplicity)obj;
        return Multiplicity.compare(this, that);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Multiplicity) {
            Multiplicity that = (Multiplicity)obj;
            return Multiplicity.compare(this, that) == 0;
        }
        return false;
    }
}

