/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.sql;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AbstractMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAnnotationAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.metamodels.core.Annotation;

public class AnnotationAspect
extends AbstractMetamodelAspect
implements SqlAnnotationAspect {
    public static final String ASPECT_ID = "sqlAspect";

    public AnnotationAspect(MetamodelEntity entity) {
        super.setMetamodelEntity(entity);
        super.setID(ASPECT_ID);
    }

    private Annotation getAnnotation(EObject eObject) {
        CoreArgCheck.isInstanceOf(Annotation.class, (Object)eObject);
        return (Annotation)eObject;
    }

    private EObject getTarget(EObject eObject) {
        Annotation annotation = this.getAnnotation(eObject);
        return annotation.getAnnotatedObject();
    }

    @Override
    public boolean isRecordType(char recordType) {
        switch (recordType) {
            case 'W': 
            case 'X': {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isQueryable(EObject eObject) {
        return true;
    }

    @Override
    public String getName(EObject eObject) {
        EObject target = this.getTarget(eObject);
        if (target == null) {
            return null;
        }
        SqlAspect aspect = AspectManager.getSqlAspect(target);
        if (aspect != null) {
            return aspect.getName(target);
        }
        ModelEditor editor = ModelerCore.getModelEditor();
        IPath path = editor.getModelRelativePathIncludingModel(target);
        if (path == null) {
            return null;
        }
        return path.lastSegment();
    }

    @Override
    public String getNameInSource(EObject eObject) {
        EObject target = this.getTarget(eObject);
        if (target == null) {
            return null;
        }
        SqlAspect aspect = AspectManager.getSqlAspect(target);
        if (aspect != null) {
            return aspect.getNameInSource(target);
        }
        return null;
    }

    @Override
    public String getFullName(EObject eObject) {
        EObject target = this.getTarget(eObject);
        if (target == null) {
            return null;
        }
        SqlAspect aspect = AspectManager.getSqlAspect(target);
        if (aspect != null) {
            return aspect.getFullName(target);
        }
        ModelEditor editor = ModelerCore.getModelEditor();
        IPath path = editor.getModelRelativePathIncludingModel(target);
        if (path == null) {
            return null;
        }
        return path.toString().replace('/', DELIMITER_CHAR);
    }

    @Override
    public Object getObjectID(EObject eObject) {
        EObject target = this.getTarget(eObject);
        if (target == null) {
            return null;
        }
        SqlAspect aspect = AspectManager.getSqlAspect(target);
        if (aspect != null) {
            return aspect.getObjectID(target);
        }
        return ModelerCore.getObjectId(target);
    }

    @Override
    public IPath getPath(EObject eObject) {
        EObject target = this.getTarget(eObject);
        if (target == null) {
            return null;
        }
        SqlAspect aspect = AspectManager.getSqlAspect(target);
        if (aspect != null) {
            return aspect.getPath(target);
        }
        ModelEditor editor = ModelerCore.getModelEditor();
        return editor.getModelRelativePathIncludingModel(target);
    }

    @Override
    public String getDescription(EObject eObject) {
        Annotation annotation = this.getAnnotation(eObject);
        return annotation.getDescription();
    }

    @Override
    public List getKeywords(EObject eObject) {
        Annotation annotation = this.getAnnotation(eObject);
        return annotation.getKeywords();
    }

    @Override
    public Map getTags(EObject eObject) {
        Annotation annotation = this.getAnnotation(eObject);
        EMap tags = annotation.getTags();
        if (tags != null && tags.size() != 0) {
            return tags.map();
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public void updateObject(EObject targetObject, EObject sourceObject) {
    }

    @Override
    public URI getURI(EObject eObject) {
        EObject target = this.getTarget(eObject);
        if (target == null) {
            return null;
        }
        return ModelerCore.getModelEditor().getUri(target);
    }

    @Override
    public URI getMetaclassURI(EObject eObject) {
        EObject target = this.getTarget(eObject);
        if (target == null) {
            return null;
        }
        return ModelerCore.getModelEditor().getUri((EObject)target.eClass());
    }
}

