/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.uml;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.MetamodelEntity;
import org.teiid.designer.core.metamodel.aspect.core.aspects.uml.AbstractExtensionUmlAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlClassifier;
import org.teiid.designer.metamodels.core.extension.XClass;

public class XClassUmlAspect
extends AbstractExtensionUmlAspect
implements UmlClassifier {
    public XClassUmlAspect(MetamodelEntity entity) {
        this.setMetamodelEntity(entity);
    }

    @Override
    public String getStereotype(Object eObject) {
        XClass xclass = this.assertXClass(eObject);
        EClass extendedClass = xclass.getExtendedClass();
        if (extendedClass != null) {
            EPackage epkg = extendedClass.getEPackage();
            Object[] params = new Object[]{epkg.getName(), extendedClass.getName()};
            String sterotype = ModelerCore.Util.getString("XClassUmlAspect.Extension_of", params);
            return sterotype;
        }
        return ModelerCore.Util.getString("XClassUmlAspect.Stereotype_UnknownExtensionClass", new Object[0]);
    }

    @Override
    public IStatus setSignature(Object eObject, String newSignature) {
        try {
            XClass xclass = this.assertXClass(eObject);
            xclass.setName(newSignature);
        }
        catch (Throwable e) {
            return new Status(4, "org.teiid.designer.core", 0, e.getMessage(), e);
        }
        return new Status(0, "org.teiid.designer.core", 0, ModelerCore.Util.getString("XClassUmlAspect.Signature_changed", new Object[0]), null);
    }

    @Override
    public Collection getRelationships(Object eObject) {
        return new ArrayList();
    }

    @Override
    public Collection getSupertypes(Object eObject) {
        return new ArrayList();
    }

    @Override
    public String getSignature(Object eObject, int showMask) {
        XClass xclass = this.assertXClass(eObject);
        StringBuffer result = new StringBuffer();
        switch (showMask) {
            case 1: {
                result.append(xclass.getName());
                break;
            }
            case 2: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">>");
                break;
            }
            case 3: {
                result.append("<<");
                result.append(this.getStereotype(eObject));
                result.append(">> ");
                result.append(xclass.getName());
                break;
            }
            default: {
                throw new TeiidDesignerRuntimeException(String.valueOf(ModelerCore.Util.getString("XClassUmlAspect.Invalid_showMask_for_getSignature", new Object[0])) + showMask);
            }
        }
        return result.toString();
    }

    @Override
    public String getEditableSignature(Object eObject) {
        return this.getSignature(eObject, 1);
    }

    @Override
    public boolean isAbstract(Object eObject) {
        return false;
    }

    protected XClass assertXClass(Object eObject) {
        CoreArgCheck.isInstanceOf(XClass.class, (Object)eObject);
        return (XClass)eObject;
    }
}

