/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.core.ModelType;

public class AmbiguousModelImportsRule
implements ObjectValidationRule {
    @Override
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(ModelAnnotation.class, (Object)eObject);
        ModelAnnotation modelAnnotation = (ModelAnnotation)eObject;
        int modelType = modelAnnotation.getModelType().getValue();
        if (modelType != ModelType.PHYSICAL && modelType != ModelType.VIRTUAL) {
            return;
        }
        EList imports = modelAnnotation.getModelImports();
        int i = 0;
        while (i < imports.size()) {
            ModelImport modelImport1 = (ModelImport)imports.get(i);
            String importName1 = modelImport1.getName();
            int j = i + 1;
            while (j < imports.size()) {
                ModelImport modelImport2 = (ModelImport)imports.get(j);
                String importName2 = modelImport2.getName();
                if (importName1.equalsIgnoreCase(importName2) && modelImport1.getModelLocation().equalsIgnoreCase(modelImport2.getModelLocation())) {
                    String modelName = ModelerCore.getModelEditor().getModelName(eObject);
                    String msg = ModelerCore.Util.getString("AmbiguousModelImportsRule.Model_{0}_imports_two_models_of_the_same_name_{1}._1", new Object[]{modelName, importName1});
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg);
                    ValidationResultImpl result = new ValidationResultImpl(eObject, eObject.eResource());
                    result.addProblem(problem);
                    context.addResult(result);
                }
                ++j;
            }
            ++i;
        }
    }
}

