/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.ObjectExtension;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.Annotation;

public class AnnotationExtensionAttributeDefaultValueRule
implements ObjectValidationRule {
    @Override
    public void validate(EObject theObject, ValidationContext theContext) {
        EMap tags;
        CoreArgCheck.isNotNull((Object)theContext);
        CoreArgCheck.isInstanceOf(Annotation.class, (Object)theObject);
        Annotation annotation = (Annotation)theObject;
        if (annotation != null && (tags = annotation.getTags()) != null && !tags.isEmpty()) {
            EObject annotatedObj = annotation.getAnnotatedObject();
            if (annotatedObj == null) {
                IPath path = ModelerCore.getModelEditor().getModelRelativePath((EObject)annotation);
                String msg = ModelerCore.Util.getString("AnnotationExtensionAttributeDefaultValueRule.NullAnnotatedObject", (Object)path);
                ModelerCore.Util.log(4, msg);
                return;
            }
            try {
                EObject temp = ModelerCore.getModelEditor().getExtension(annotatedObj);
                if (temp instanceof ObjectExtension) {
                    ObjectExtension extension = (ObjectExtension)temp;
                    for (Object propertyName : tags.keySet()) {
                        if (extension.isValid(propertyName)) continue;
                        ValidationResultImpl result = new ValidationResultImpl(annotation, annotatedObj);
                        String name = ModelerCore.getModelEditor().getName(annotatedObj);
                        if (name == null) {
                            IPath path = ModelerCore.getModelEditor().getModelRelativePath(annotatedObj);
                            name = path.toString();
                        }
                        Object[] params = new Object[]{propertyName, tags.get(propertyName), name};
                        String msg = ModelerCore.Util.getString("AnnotationExtensionAttributeDefaultValueRule.ExtensionPropertyDefaultValueInvalid", (Object)params);
                        ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                        result.addProblem(problem);
                        theContext.addResult(result);
                    }
                }
            }
            catch (ModelerCoreException theException) {
                ModelerCore.Util.log((Throwable)theException);
                ValidationResultImpl result = new ValidationResultImpl(annotation);
                IPath path = ModelerCore.getModelEditor().getModelRelativePath((EObject)annotation);
                String msg = ModelerCore.Util.getString("AnnotationExtensionAttributeDefaultValueRule.UnexpectedError", (Object)path);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem(problem);
                theContext.addResult(result);
            }
        }
    }
}

