/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ResourceValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelImport;

public class DeletedXmlRelationalImportRule
implements ResourceValidationRule {
    @Override
    public void validate(Resource resource, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)context);
        if (ModelUtil.isModelFile(resource)) {
            try {
                if (ModelUtil.isPhysical(resource)) {
                    List imports = ModelUtil.getModel(resource).getModelImports();
                    for (ModelImport imp : imports) {
                        if (!imp.getName().equalsIgnoreCase("XMLFileConnectorExtensions") && !imp.getName().equalsIgnoreCase("XMLHttpConnectorExtensions") && !imp.getName().equalsIgnoreCase("XMLSOAPConnectorExtensions")) continue;
                        ValidationResultImpl result = new ValidationResultImpl(resource, context);
                        ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, ModelerCore.Util.getString("DeletedXmlRelationalRule.invalidmodel", new Object[]{imp.getName()}));
                        result.addProblem(problem);
                        context.addResult(result);
                    }
                }
            }
            catch (ModelWorkspaceException e) {
                ValidationResultImpl result = new ValidationResultImpl(resource, resource);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, e.getLocalizedMessage());
                result.addProblem(problem);
                context.addResult(result);
            }
        }
    }
}

