/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.util.UriValidator;

public final class InvalidNamespaceUriRule
implements ObjectValidationRule {
    @Override
    public void validate(EObject theObject, ValidationContext theContext) {
        CoreArgCheck.isInstanceOf(ModelAnnotation.class, (Object)theObject);
        String uri = ((ModelAnnotation)theObject).getNamespaceUri();
        try {
            IStatus status = UriValidator.validate((String)uri);
            if (!status.isOK()) {
                ValidationResultImpl result = new ValidationResultImpl(theObject, theObject);
                ValidationProblemImpl problem = new ValidationProblemImpl(status.getCode(), status.getSeverity(), status.getMessage());
                result.addProblem(problem);
                theContext.addResult(result);
            }
        }
        catch (RuntimeException theException) {
            ValidationResultImpl result = new ValidationResultImpl(theObject, theObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, theException.getLocalizedMessage());
            result.addProblem(problem);
            theContext.addResult(result);
        }
    }
}

