/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class ModelAnnotationUuidRule
implements ObjectValidationRule {
    @Override
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isNotNull((Object)context);
        CoreArgCheck.isInstanceOf(ModelAnnotation.class, (Object)eObject);
        ModelEditor editor = ModelerCore.getModelEditor();
        String uuidString = ModelerCore.getObjectIdString(eObject);
        if (uuidString == null) {
            String pathInModel = editor.getModelRelativePathIncludingModel(eObject).toString();
            ValidationResultImpl result = new ValidationResultImpl(eObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, ModelerCore.Util.getString("ModelAnnotationUuidRule.0", (Object)pathInModel));
            result.addProblem(problem);
            context.addResult(result);
        } else {
            boolean isDuplicate = context.containsUuid(uuidString);
            if (isDuplicate) {
                String pathInModel = editor.getModelRelativePathIncludingModel(eObject).toString();
                ValidationResultImpl result = new ValidationResultImpl(eObject);
                String modelName = editor.getModelName(eObject);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, ModelerCore.Util.getString("ModelAnnotationUuidRule.1", new Object[]{pathInModel, uuidString, modelName}));
                result.addProblem(problem);
                context.addResult(result);
            } else {
                context.addUuidToContext(uuidString);
            }
        }
    }
}

