/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class NullModelTypeRule
implements StructuralFeatureValidationRule {
    private int featureID;

    public NullModelTypeRule(int featureID) {
        this.featureID = featureID;
    }

    @Override
    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (eObject == null || !(eObject instanceof ModelAnnotation)) {
            return;
        }
        ValidationResultImpl result = new ValidationResultImpl(eObject, eObject.eResource());
        if (value == null) {
            URI uri = eObject.eResource().getURI();
            Object[] params = new Object[]{URI.decode((String)uri.toString())};
            String msg = ModelerCore.Util.getString("NullModelTypeRule.The_model_type_value_may_not_be_null_1", params);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
    }
}

