/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class NullPrimaryMetamodelUriRule
implements StructuralFeatureValidationRule {
    private int featureID;

    public NullPrimaryMetamodelUriRule(int featureID) {
        this.featureID = featureID;
    }

    @Override
    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (eObject == null || !(eObject instanceof ModelAnnotation)) {
            return;
        }
        Resource resource = eObject.eResource();
        if (resource != null) {
            EList contents = resource.getContents();
            int numRoots = contents.size();
            if (numRoots == 0) {
                return;
            }
            if (numRoots == 1 && contents.contains(eObject)) {
                return;
            }
        }
        ValidationResultImpl result = new ValidationResultImpl(eObject, eObject.eResource());
        if (value == null || value instanceof String && ((String)value).trim().length() == 0) {
            URI uri = eObject.eResource().getURI();
            Object[] params = new Object[]{URI.decode((String)uri.toString())};
            String msg = ModelerCore.Util.getString("NullPrimaryMetamodelUriRule.The_primary_metamodel_URI_value_may_not_be_null_1", params);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
    }
}

