/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.aspect.core.aspects.validation.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.extension.XClass;
import org.teiid.designer.metamodels.core.extension.XPackage;

public class XClassUniqueExtendedClassInXPackageRule
implements ObjectValidationRule {
    @Override
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(XPackage.class, (Object)eObject);
        XPackage xpackage = (XPackage)eObject;
        Resource resource = xpackage.eResource();
        if (resource == null) {
            return;
        }
        HashMap<EClass, ArrayList<XClass>> xclassesByMetaclasses = new HashMap<EClass, ArrayList<XClass>>();
        EList xclasses = xpackage.getEClassifiers();
        for (EClassifier classifier : xclasses) {
            XClass xclass;
            EClass extendedMetaclass;
            if (!(classifier instanceof XClass) || (extendedMetaclass = (xclass = (XClass)classifier).getExtendedClass()) == null) continue;
            ArrayList<XClass> xclassesForMetaclass = (ArrayList<XClass>)xclassesByMetaclasses.get(extendedMetaclass);
            if (xclassesForMetaclass == null) {
                xclassesForMetaclass = new ArrayList<XClass>(5);
                xclassesByMetaclasses.put(extendedMetaclass, xclassesForMetaclass);
            }
            xclassesForMetaclass.add(xclass);
        }
        for (Map.Entry entry : xclassesByMetaclasses.entrySet()) {
            List xclassesWithSameMetaclass = (List)entry.getValue();
            int numDuplicates = xclassesWithSameMetaclass.size();
            if (numDuplicates <= 1) continue;
            Integer numOthers = new Integer(numDuplicates - 1);
            for (XClass xclass : xclassesWithSameMetaclass) {
                ValidationResultImpl result = new ValidationResultImpl(xclass);
                Object[] params = new Object[]{numOthers};
                String msg = ModelerCore.Util.getString("XClassUniqueExtendedClassInXPackageRule.ExtendedClassHasSameMetaclassAs_n_Others", params);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem(problem);
                context.addResult(result);
            }
        }
    }
}

