/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.metamodel.util;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.ModelVisitor;

public abstract class AbstractNameFinder
implements ModelVisitor {
    protected final String nameToMatch;
    protected Collection matchingEObjects;
    protected boolean isPartialName;

    public AbstractNameFinder(String nameToMatch, boolean isPartialName) {
        CoreArgCheck.isNotEmpty((String)nameToMatch);
        this.nameToMatch = nameToMatch.toUpperCase();
        this.isPartialName = isPartialName;
        this.matchingEObjects = new HashSet();
    }

    @Override
    public boolean visit(Resource resource) {
        return true;
    }

    @Override
    public boolean visit(EObject eObject) {
        return !(!this.isPartialName ? !this.matchingEObjects.isEmpty() : this.matchingEObjects.contains(eObject));
    }

    protected boolean foundMatch(String fullName, EObject eObject) {
        if (this.isPartialName) {
            if (fullName.endsWith(this.nameToMatch)) {
                this.matchingEObjects.add(eObject);
                return true;
            }
        } else if (this.nameToMatch.equals(fullName)) {
            this.matchingEObjects.add(eObject);
            return true;
        }
        return false;
    }

    protected boolean isParent(String parentName) {
        if (!this.isPartialName && this.nameToMatch.startsWith(parentName)) {
            return true;
        }
        return this.isPartialName;
    }

    public Collection getMatchingEObjects() {
        return this.matchingEObjects;
    }
}

