/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.reader;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.teiid.designer.core.reader.ZipReaderCallback;

public class ZipReader {
    private final File file;

    public ZipReader(File file) {
        this.file = file;
    }

    public void readEntry(String fileName, ZipReaderCallback callback) throws Exception {
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            zipFile = new ZipFile(this.file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.getName().equals(fileName)) continue;
                inputStream = zipFile.getInputStream(zipEntry);
                callback.process(inputStream);
                break;
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }
}

