/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramEntity;

public class ExternalReferenceVisitor
implements ModelVisitor {
    public static final boolean DEFAULT_RESOLVE_REFERENCE = false;
    public static final boolean DEFAULT_INCLUDE_RESOLVED_REFERENCES = true;
    public static final boolean DEFAULT_INCLUDE_DIAGRAM_REFERENCES = true;
    private final Map referencedObjectsByResourceUri;
    private final Resource resource;
    private boolean includeResolvedReferences = true;
    private boolean includeDiagramReferences = true;

    public ExternalReferenceVisitor(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        this.resource = resource;
        this.referencedObjectsByResourceUri = new HashMap();
    }

    public Resource getResource() {
        return this.resource;
    }

    public boolean isIncludeResolvedReferences() {
        return this.includeResolvedReferences;
    }

    public void setIncludeResolvedReferences(boolean b) {
        this.includeResolvedReferences = b;
    }

    public boolean isIncludeDiagramReferences() {
        return this.includeDiagramReferences;
    }

    public void setIncludeDiagramReferences(boolean b) {
        this.includeDiagramReferences = b;
    }

    @Override
    public boolean visit(Resource resource) {
        return true;
    }

    @Override
    public boolean visit(EObject object) {
        if (!this.includeDiagramReferences && (object instanceof DiagramEntity || object instanceof Diagram)) {
            return false;
        }
        for (EReference eReference : object.eClass().getEAllReferences()) {
            if (eReference.isContainment() || eReference.isContainer() || eReference.isVolatile()) continue;
            Object value = object.eGet((EStructuralFeature)eReference, false);
            if (eReference.isMany()) {
                for (Object valueInList : (List)value) {
                    if (!(valueInList instanceof EObject)) continue;
                    this.processReference((EObject)valueInList);
                }
                continue;
            }
            if (value == null || !(value instanceof EObject)) continue;
            this.processReference((EObject)value);
        }
        return true;
    }

    public boolean processReference(EObject object) {
        if (object == null) {
            return false;
        }
        if (object.eIsProxy()) {
            if (object instanceof InternalEObject) {
                InternalEObject iObject = (InternalEObject)object;
                URI proxyUri = iObject.eProxyURI();
                CoreArgCheck.isNotNull((Object)proxyUri);
                this.recordResourceUsage(proxyUri, object);
            }
            return false;
        }
        Resource resourceForObject = object.eResource();
        if (resourceForObject == this.resource) {
            return false;
        }
        if (resourceForObject != null) {
            this.recordResourceUsage(resourceForObject, object);
        }
        return false;
    }

    public Collection getExternalReferences() {
        return this.referencedObjectsByResourceUri.values();
    }

    protected void recordResourceUsage(Resource externalResource, EObject referencedObject) {
        URI resourceUri = externalResource.getURI();
        ExternalReferences refedObjs = this.getReferencedObjects(resourceUri, true);
        refedObjs.setResource(externalResource);
        if (this.includeResolvedReferences) {
            refedObjs.addReferencedObject(referencedObject);
        }
    }

    protected void recordResourceUsage(URI uriToExternalObject, EObject referencedObject) {
        URI resourceUri = uriToExternalObject.trimFragment();
        if (resourceUri != null && resourceUri.isRelative()) {
            resourceUri = resourceUri.resolve(this.resource.getURI());
        }
        ExternalReferences refedObjs = this.getReferencedObjects(resourceUri, true);
        refedObjs.addReferencedObject(referencedObject);
    }

    protected ExternalReferences getReferencedObjects(URI resourceUri, boolean createIfNeeded) {
        ExternalReferences refedObjs = (ExternalReferences)this.referencedObjectsByResourceUri.get(resourceUri);
        if (refedObjs == null && createIfNeeded) {
            refedObjs = new ExternalReferences(resourceUri);
            this.referencedObjectsByResourceUri.put(resourceUri, refedObjs);
        }
        return refedObjs;
    }

    public class ExternalReferences {
        private final URI resourceUri;
        private final Set objects;
        private Resource resource;

        protected ExternalReferences(URI resourceUri) {
            CoreArgCheck.isNotNull((Object)resourceUri);
            this.resourceUri = resourceUri;
            this.objects = new HashSet();
        }

        protected void addReferencedObject(EObject referencedObject) {
            this.objects.add(referencedObject);
        }

        public Collection getReferencedObjects() {
            return this.objects;
        }

        public URI getResourceUri() {
            return this.resourceUri;
        }

        public Resource getResource() {
            return this.resource;
        }

        protected void setResource(Resource resource) {
            if (this.resource != null) {
                CoreArgCheck.isTrue((resource == this.resource ? 1 : 0) != 0, (String)"Resource cannot be reset to itself");
                return;
            }
            this.resource = resource;
        }
    }
}

