/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.refactor.ReferenceUpdator;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;
import org.teiid.designer.metamodels.core.ModelType;

public class ModelImportReferenceUpdator
implements ReferenceUpdator {
    @Override
    public void updateEObject(EObject eObject, Map oldToNewObjects) {
        ModelImport modelImport;
        ModelAnnotation newModel;
        CoreArgCheck.isNotNull((Object)eObject);
        CoreArgCheck.isNotNull((Object)oldToNewObjects);
        if (eObject instanceof ModelImport && (newModel = this.getNewResourceModelAnnotation(modelImport = (ModelImport)eObject, oldToNewObjects)) != null) {
            Resource newResource = newModel.eResource();
            String resourcePath = WorkspaceResourceFinderUtil.getWorkspaceUri(newResource);
            if (resourcePath == null) {
                return;
            }
            Resource eResource = eObject.eResource();
            URI resourceURI = eResource.getURI();
            URI importURI = newResource.getURI();
            String uriString = URI.decode((String)importURI.toString());
            if (importURI.isFile()) {
                URI deresolvedURI;
                boolean deresolve;
                boolean bl = deresolve = resourceURI != null && !resourceURI.isRelative() && resourceURI.isHierarchical();
                if (deresolve && !importURI.isRelative() && (deresolvedURI = importURI.deresolve(resourceURI, true, true, false)).hasRelativePath()) {
                    importURI = deresolvedURI;
                    uriString = URI.decode((String)importURI.toString());
                }
                modelImport.setModelLocation(uriString);
            } else {
                modelImport.setModelLocation(uriString);
            }
            modelImport.setName(this.getResourceName(newResource));
            modelImport.setModelType(newModel.getModelType());
            modelImport.setPrimaryMetamodelUri(newModel.getPrimaryMetamodelUri());
            modelImport.setUuid(ModelerCore.getObjectIdString((EObject)newModel));
        }
    }

    private ModelAnnotation getNewResourceModelAnnotation(ModelImport modelImport, Map oldToNewObjects) {
        String primaryMetamodelUri = modelImport.getPrimaryMetamodelUri();
        String resourcePath = modelImport.getPath();
        ModelType modelType = modelImport.getModelType();
        for (Object keyObj : oldToNewObjects.keySet()) {
            Resource oldModelResource;
            String modelPath;
            if (!(keyObj instanceof ModelAnnotation)) continue;
            ModelAnnotation modelAnnotation = (ModelAnnotation)keyObj;
            if (primaryMetamodelUri != null && !primaryMetamodelUri.equals(modelAnnotation.getPrimaryMetamodelUri())) continue;
            if (modelType != null) {
                int oldType;
                int type = modelType.getValue();
                ModelType oldModelType = modelAnnotation.getModelType();
                if (oldModelType != null && type != (oldType = oldModelType.getValue())) continue;
            }
            if (resourcePath != null && !resourcePath.equals(modelPath = WorkspaceResourceFinderUtil.getWorkspaceUri(oldModelResource = modelAnnotation.eResource()))) continue;
            return (ModelAnnotation)oldToNewObjects.get(keyObj);
        }
        return null;
    }

    private String getResourceName(Resource resource) {
        int index;
        CoreArgCheck.isNotNull((Object)resource);
        URI resourceUri = resource.getURI();
        String modelNameWithExt = resourceUri.lastSegment();
        String extension = resourceUri.fileExtension();
        if (extension != null && (index = modelNameWithExt.indexOf(extension)) > 1) {
            return modelNameWithExt.substring(0, index - 1);
        }
        return modelNameWithExt;
    }
}

