/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.refactor.ModelRefactorCommand;
import org.teiid.designer.core.refactor.OrganizeImportCommandHelper;
import org.teiid.designer.core.refactor.OrganizeImportCommandHelperNonXsd;
import org.teiid.designer.core.refactor.OrganizeImportCommandHelperXsd;
import org.teiid.designer.core.refactor.OrganizeImportHandler;
import org.teiid.designer.core.refactor.PathPair;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class OrganizeImportCommand
implements ModelRefactorCommand {
    private OrganizeImportCommandHelper organizeImportCommandHelper;
    private CoreFactory factory;
    private Resource resource;
    private OrganizeImportHandler handler;
    private Collection<PathPair> paths;
    private final Object factoryLock = new Object();

    public OrganizeImportCommand() {
        this.resetOrganizeImportHelper();
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setHandler(OrganizeImportHandler handler) {
        this.handler = handler;
    }

    public OrganizeImportHandler getHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreFactory getFactory() {
        if (this.factory == null) {
            Object object = this.factoryLock;
            synchronized (object) {
                if (this.factory == null) {
                    this.factory = CoreFactory.eINSTANCE;
                }
            }
        }
        return this.factory;
    }

    public void setFactory(CoreFactory factory) {
        this.factory = factory;
    }

    public boolean isIncludeDiagramReferences() {
        return this.organizeImportCommandHelper.isIncludeDiagramReferences();
    }

    public void setIncludeDiagramReferences(boolean includeDiagramReferences) {
        this.organizeImportCommandHelper.setIncludeDiagramReferences(includeDiagramReferences);
    }

    @Override
    public IStatus canExecute() {
        if (this.resource == null) {
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.Organizing_imports_must_be_performed_on_a_Resource", new Object[0]);
            Status status = new Status(4, "org.teiid.designer.core", 1001, msg, null);
            return status;
        }
        IResource iResource = WorkspaceResourceFinderUtil.findIResource(this.resource);
        if (iResource != null && ModelUtil.isIResourceReadOnly(iResource)) {
            String msg = ModelerCore.Util.getString("OrganizeImportCommand.0", (Object)iResource.getFullPath());
            Status status = new Status(4, "org.teiid.designer.core", 1001, msg, null);
            return status;
        }
        String msg = ModelerCore.Util.getString("OrganizeImportCommand.Ready_to_organize_import", new Object[]{this.resource.getURI()});
        return new Status(0, "org.teiid.designer.core", 1000, msg, null);
    }

    @Override
    public IStatus execute(IProgressMonitor monitor) {
        this.resetOrganizeImportHelper();
        return this.organizeImportCommandHelper.execute(monitor);
    }

    public List getModelImports() {
        return this.organizeImportCommandHelper.getModelImports();
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public Collection getAffectedObjects() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getLabel() {
        return null;
    }

    @Override
    public Collection getPostExecuteMessages() {
        return null;
    }

    @Override
    public Collection getResult() {
        return null;
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean canRedo() {
        return false;
    }

    protected void setRefactoredPaths(Collection<PathPair> paths) {
        this.paths = paths;
    }

    protected String getUUIDMatchPattern(char recordType, String uuid) {
        CoreArgCheck.isNotNull((Object)uuid);
        String patternStr = null;
        patternStr = 'M' == recordType ? "" + recordType + '\u00a0' + '*' + '\u00a0' + '*' + '\u00a0' + '*' + '\u00a0' + uuid + '\u00a0' + '*' : "" + recordType + '\u00a0' + '*' + '\u00a0' + uuid + '\u00a0' + '*';
        return patternStr;
    }

    protected ModelAnnotation getModelAnnotation(Resource resource) {
        if (resource instanceof EmfResource) {
            EmfResource emfResource = (EmfResource)resource;
            return emfResource.getModelAnnotation();
        }
        return null;
    }

    protected String getModelName(URI resourceUri) {
        int index;
        String modelNameWithExt = resourceUri.lastSegment();
        String extension = resourceUri.fileExtension();
        if (extension != null && (index = modelNameWithExt.indexOf(extension)) > 1) {
            return modelNameWithExt.substring(0, index - 1);
        }
        return modelNameWithExt;
    }

    private void resetOrganizeImportHelper() {
        if (this.resource instanceof XSDResourceImpl) {
            if (this.organizeImportCommandHelper == null || !(this.organizeImportCommandHelper instanceof OrganizeImportCommandHelperXsd)) {
                this.organizeImportCommandHelper = new OrganizeImportCommandHelperXsd();
            }
        } else if (this.organizeImportCommandHelper == null || !(this.organizeImportCommandHelper instanceof OrganizeImportCommandHelperNonXsd)) {
            this.organizeImportCommandHelper = new OrganizeImportCommandHelperNonXsd();
        }
        this.organizeImportCommandHelper.setResource(this.resource);
        this.organizeImportCommandHelper.setHandler(this.handler);
        this.organizeImportCommandHelper.setFactory(this.factory);
        this.organizeImportCommandHelper.setRefactoredPaths(this.paths);
    }
}

