/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.ImportsAspect;
import org.teiid.designer.core.refactor.OrganizeImportCommandHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;

public class OrganizeImportCommandHelperXsd
extends OrganizeImportCommandHelper {
    protected OrganizeImportCommandHelperXsd() {
    }

    @Override
    protected IStatus execute(IProgressMonitor monitor) {
        return this.process(monitor);
    }

    private Iterator getResourceSchemaContents() {
        if (((XSDResourceImpl)this.getResource()).getSchema() != null) {
            return ((XSDResourceImpl)this.getResource()).getSchema().getContents().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    private IStatus process(IProgressMonitor monitor) {
        Iterator iter = this.getResourceSchemaContents();
        while (iter.hasNext()) {
            ModelResource oldResource;
            IPath importPath;
            EObject eobject = (EObject)iter.next();
            if (eobject instanceof XSDAnnotation) continue;
            if (eobject instanceof XSDNamedComponent) break;
            ImportsAspect importsAspect = AspectManager.getModelImportsAspect(eobject);
            if (importsAspect == null || (importPath = this.getHelper().findPath(eobject, importsAspect)) == null || (oldResource = ModelerCore.getModelWorkspace().findModelResource(importPath)) == null) continue;
            try {
                oldResource.unload();
                oldResource.close();
                IFile newIFile = this.createAndSaveResource(monitor, importPath);
                if (newIFile != null) {
                    importsAspect.setModelLocation(eobject, URI.createFileURI((String)newIFile.getLocation().toFile().getAbsolutePath()));
                }
                this.getResource().setModified(true);
            }
            catch (ModelWorkspaceException e) {
                Object[] params = new Object[]{this.getResource().getURI(), e.getLocalizedMessage()};
                String msg = ModelerCore.Util.getString("OrganizeImportCommand.Error_while_organizing_imports", params);
                return new Status(4, "org.teiid.designer.core", 1002, msg, (Throwable)((Object)e));
            }
        }
        return new Status(0, "org.teiid.designer.core", 1004, ModelerCore.Util.getString("OrganizeImportCommand.complete", new Object[0]), null);
    }

    private IFile createAndSaveResource(IProgressMonitor monitor, IPath importPath) throws ModelWorkspaceException {
        IFile tmpFile = WorkspaceResourceFinderUtil.findIResourceByPath(importPath);
        if (tmpFile != null) {
            ModelResource newResource = ModelerCore.create(tmpFile);
            newResource.save(monitor, true);
        }
        return tmpFile;
    }
}

