/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResourceFilter;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;

public class RelatedResourceFinder {
    private static final ModelResourceFilter RESOURCE_FILTER = new ModelResourceFilter();
    private final IResource sourceResource;

    public RelatedResourceFinder(IResource sourceResource) {
        this.sourceResource = sourceResource;
    }

    private boolean isClosedProject(IResource resource) {
        return resource instanceof IProject && !((IProject)resource).isOpen();
    }

    private Collection<IFile> findDependentResources(IResource resource) {
        Collection<Object> dependentResources = Collections.emptyList();
        try {
            if (this.isClosedProject(resource)) {
                return dependentResources;
            }
            if (resource instanceof IContainer) {
                if (resource.exists()) {
                    IContainer folder = (IContainer)resource;
                    IResource[] resources = folder.members();
                    dependentResources = new HashSet();
                    int idx = 0;
                    while (idx < resources.length) {
                        IResource depResource = resources[idx];
                        if (ModelUtil.isModelFile(depResource.getFullPath())) {
                            dependentResources.add((IFile)depResource);
                        }
                        dependentResources.addAll(this.findDependentResources(depResource));
                        ++idx;
                    }
                }
            } else {
                dependentResources = WorkspaceResourceFinderUtil.getResourcesThatUse(resource, RESOURCE_FILTER, 2);
            }
        }
        catch (CoreException ce) {
            ModelerCore.Util.log((Throwable)ce);
        }
        return dependentResources;
    }

    private Collection<IFile> findDependentResources() {
        return this.findDependentResources(this.sourceResource);
    }

    private Collection<IFile> findDependencyResources(IResource resource) {
        HashSet<IFile> dependencyResources = new HashSet<IFile>();
        try {
            if (this.isClosedProject(resource)) {
                return dependencyResources;
            }
            if (resource instanceof IContainer) {
                IContainer folder = (IContainer)resource;
                IResource[] resources = folder.members();
                int idx = 0;
                while (idx < resources.length) {
                    dependencyResources.addAll(this.findDependencyResources(resources[idx]));
                    ++idx;
                }
            } else {
                dependencyResources.addAll(WorkspaceResourceFinderUtil.getDependentResources(resource));
            }
        }
        catch (CoreException ce) {
            ModelerCore.Util.log((Throwable)ce);
        }
        return dependencyResources;
    }

    private Collection<IFile> findDependencyResources() {
        return this.findDependencyResources(this.sourceResource);
    }

    public Collection<IFile> findRelatedResources(Relationship typeOfRelationship) {
        switch (typeOfRelationship) {
            case DEPENDENT: {
                return this.findDependentResources();
            }
            case DEPENDENCY: {
                return this.findDependencyResources();
            }
            case ALL: {
                HashSet<IFile> files = new HashSet<IFile>();
                files.addAll(this.findDependentResources());
                files.addAll(this.findDependencyResources());
                return files;
            }
        }
        throw new IllegalStateException();
    }

    public static enum Relationship {
        DEPENDENT,
        DEPENDENCY,
        ALL;

    }
}

