/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.refactor;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.teiid.designer.core.refactor.ResourceStatus;

public class ResourceStatusList {
    Collection<IStatus> statusList;
    Collection<IStatus> problemList;
    Collection<IFile> resourceList;
    int highestSeverity = 0;

    public ResourceStatusList(Collection<IFile> c) {
        this(c, 4);
    }

    public ResourceStatusList(Collection<IFile> c, int readOnlySeverity) {
        this.statusList = new ArrayList<IStatus>(c.size());
        this.problemList = new ArrayList<IStatus>(c.size());
        this.resourceList = new ArrayList<IFile>(c.size());
        for (IFile file : c) {
            this.resourceList.add(file);
            ResourceStatus status = new ResourceStatus(readOnlySeverity, (IResource)file);
            this.statusList.add((IStatus)status);
            if (status.isOK()) continue;
            this.problemList.add((IStatus)status);
            if (status.getSeverity() <= this.highestSeverity) continue;
            this.highestSeverity = status.getSeverity();
        }
    }

    public Collection getStatusList() {
        return this.statusList;
    }

    public Collection<IFile> getResourceList() {
        return this.resourceList;
    }

    public Collection<IStatus> getProblems() {
        return this.problemList;
    }

    public int getHighestSeverity() {
        return this.highestSeverity;
    }
}

