/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.common.xmi.XMIHeaderReader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.resource.EObjectCache;
import org.teiid.designer.core.resource.EObjectCacheHolder;
import org.teiid.designer.core.resource.EObjectCacheImpl;
import org.teiid.designer.core.resource.EProxyCacheHolder;
import org.teiid.designer.core.resource.EResource;
import org.teiid.designer.core.resource.EResourceLoader;
import org.teiid.designer.core.resource.EResourceXmiHelper;
import org.teiid.designer.core.resource.EResourceXmiSaveImpl;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.resource.XResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.util.ModelObjectCollector;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;

public class EResourceImpl
extends XMIResourceImpl
implements EResource,
EProxyCacheHolder,
EObjectCacheHolder,
EmfResource,
XResource {
    public static final char UUID_PROTOCOL_DELIMITER = '/';
    static EObject[] EMPTY_EOBJECT_ARRAY = new EObject[0];
    private static final boolean DEBUG = false;
    private Map prefixesToURIs;
    private ModelContents modelContents;
    private int loadedCount;
    private EObjectCache eProxyCache;
    private EObjectCache eObjectCache;

    public EResourceImpl(URI uri) {
        super(uri);
        CoreArgCheck.isNotNull((Object)uri);
        this.loadedCount = 0;
        this.modelContents = new ModelContents((Resource)this);
        this.prefixesToURIs = new HashMap();
        this.eProxyCache = new EObjectCacheImpl();
        this.eObjectCache = new EObjectCacheImpl();
        this.eAdapters().add((Object)new EObjectCacheAdapter());
    }

    protected XMLHelper createXMLHelper() {
        return new EResourceXmiHelper((XMLResource)this);
    }

    protected XMLSave createXMLSave() {
        return new EResourceXmiSaveImpl(this.createXMLHelper(), this);
    }

    protected XMLLoad createXMLLoad() {
        return new EResourceLoader(this.createXMLHelper());
    }

    public void recordUUID(EObject eObject, boolean recursive) {
    }

    @Override
    public Annotation getAnnotation(EObject eobj) {
        return this.getModelContents().getAnnotation(eobj);
    }

    @Override
    public AnnotationContainer getAnnotationContainer(boolean createIfNeeded) {
        return this.getModelContents().getAnnotationContainer(createIfNeeded);
    }

    public void doLoad(InputStream inputStream, Map options) throws IOException {
        CoreArgCheck.isNotNull((Object)inputStream);
        ++this.loadedCount;
        XMLLoad xmlLoad = this.createXMLLoad();
        xmlLoad.load((XMLResource)this, inputStream, options);
        this.setPrefixToUriMap(xmlLoad);
        this.getEProxyCache().clear();
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        this.moveModelAnnotation();
        this.setProductInfoOnModelAnnotation();
        super.doSave(outputStream, options);
    }

    protected void doUnload() {
        ModelObjectCollector moc = new ModelObjectCollector((Resource)this);
        this.getEProxyCache().clear();
        Iterator iter = moc.getEObjects().iterator();
        while (iter.hasNext()) {
            this.addToEProxyCache((EObject)iter.next());
        }
        super.doUnload();
        this.getEObjectCache().clear();
        this.setModified(false);
        this.modelContents = null;
        for (EObject eObject : moc.getEObjects()) {
            EClass eClass = eObject.eClass();
            for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                if (!feature.isChangeable()) continue;
                eObject.eUnset(feature);
            }
        }
    }

    public String getURIFragment(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        ObjectID id = ModelerCore.getObjectId(eObject);
        return id == null ? null : id.toString('/');
    }

    public EObject getEObject(String uriFragment) {
        ObjectID id;
        if (uriFragment != null && uriFragment.startsWith("mmuuid") && (id = this.getObjectIDFromString(uriFragment)) != null) {
            return this.findInEObjectCache(id);
        }
        return null;
    }

    protected EObject getEObjectByID(String id) {
        return this.getEObject(id);
    }

    public EList getContents() {
        if (this.contents == null) {
            this.contents = new EResourceContentsEList(this);
        }
        return this.contents;
    }

    public void detached(EObject eObject) {
        this.removeFromEObjectCache(eObject, true);
        super.detached(eObject);
    }

    public void attached(EObject eObject) {
        this.addToEObjectCache(eObject, true);
        super.attached(eObject);
    }

    @Override
    public Container getContainer() {
        return null;
    }

    @Override
    public EObject getEObject(Object key) {
        if (key instanceof URI) {
            return this.getResourceSet().getEObject(this.uri, true);
        }
        if (key instanceof ObjectID) {
            return this.getEObject((ObjectID)key);
        }
        return null;
    }

    @Override
    public boolean isVisible() {
        boolean isVisible = true;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            isVisible = this.getModelContents().getModelAnnotation().isVisible();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                isVisible = header.isVisible();
            }
        }
        return isVisible;
    }

    @Override
    public List getNamespacePrefixToUris() {
        return null;
    }

    @Override
    public int getLoadedCount() {
        return this.loadedCount;
    }

    @Override
    public String getDescription() {
        String description = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            description = this.getModelContents().getModelAnnotation().getDescription();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                description = header.getDescription();
            }
        }
        return description;
    }

    @Override
    public ModelType getModelType() {
        ModelType type = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            type = this.getModelContents().getModelAnnotation().getModelType();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                type = ModelType.get((String)header.getModelType());
            }
        }
        return type;
    }

    @Override
    public URI getPrimaryMetamodelUri() {
        String primaryMetamodelUri = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            primaryMetamodelUri = this.getModelContents().getModelAnnotation().getPrimaryMetamodelUri();
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null) {
                primaryMetamodelUri = header.getPrimaryMetamodelURI();
            }
        }
        if (CoreStringUtil.isEmpty(primaryMetamodelUri)) {
            return null;
        }
        return URI.createURI((String)primaryMetamodelUri);
    }

    @Override
    public ObjectID getUuid() {
        ObjectID uuid = null;
        if (this.isLoaded() && this.getModelContents().getModelAnnotation() != null) {
            uuid = ModelerCore.getObjectId((EObject)this.getModelContents().getModelAnnotation());
        } else {
            XMIHeader header = this.doGetXmiHeader();
            if (header != null && header.getUUID() != null) {
                uuid = this.getObjectIDFromString(header.getUUID());
            }
        }
        return uuid;
    }

    @Override
    public ModelContents getModelContents() {
        if (this.modelContents == null) {
            this.modelContents = new ModelContents((Resource)this);
        }
        return this.modelContents;
    }

    @Override
    public Map getNamespacePrefixToUrisMap() {
        return this.prefixesToURIs;
    }

    @Override
    public EObject getEObject(ObjectID key) {
        return this.findInEObjectCache(key);
    }

    @Override
    public EObject getEProxy(ObjectID key) {
        return this.findInEProxyCache(key);
    }

    @Override
    public ModelAnnotation getModelAnnotation() {
        ModelAnnotation modelAnnotation = null;
        for (EObject eObj : this.getContents()) {
            if (!(eObj instanceof ModelAnnotation)) continue;
            modelAnnotation = (ModelAnnotation)eObj;
            break;
        }
        return modelAnnotation;
    }

    protected void moveModelAnnotation() {
        ModelAnnotation modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation != null) {
            Resource resource = modelAnnotation.eResource();
            if (resource == null) {
                this.getContents().add(0, (Object)modelAnnotation);
            } else if (!(this.getContents().get(0) instanceof ModelAnnotation)) {
                this.getContents().move(0, (Object)modelAnnotation);
            }
        }
    }

    protected void setProductInfoOnModelAnnotation() {
        ModelAnnotation modelAnnotation = this.getModelAnnotation();
        if (modelAnnotation != null) {
            modelAnnotation.setProducerName(ModelerCore.ILicense.PRODUCER_NAME);
            modelAnnotation.setProducerVersion(ModelerCore.ILicense.VERSION);
        }
    }

    protected ObjectID getObjectIDFromString(String uuidString) {
        if (uuidString == null || uuidString.length() == 0) {
            return null;
        }
        try {
            return IDGenerator.getInstance().stringToObject(uuidString);
        }
        catch (InvalidIDException invalidIDException) {
            return null;
        }
    }

    protected XMIHeader doGetXmiHeader(URI theUri) {
        File f;
        XMIHeader header = null;
        if (theUri != null && theUri.isFile() && (f = new File(this.getURI().toFileString())).isFile() && f.exists()) {
            try {
                header = XMIHeaderReader.readHeader((File)f);
            }
            catch (TeiidDesignerException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
        return header;
    }

    protected XMIHeader doGetXmiHeader() {
        return this.doGetXmiHeader(this.getURI());
    }

    protected void setPrefixToUriMap(XMLLoad xmlLoad) {
        XMLHelper xmiHelper;
        if (xmlLoad instanceof EResourceLoader && (xmiHelper = ((EResourceLoader)xmlLoad).getXMLHelper()) instanceof EResourceXmiHelper) {
            this.prefixesToURIs.clear();
            this.prefixesToURIs = ((EResourceXmiHelper)xmiHelper).getPrefixesToURIs();
        }
    }

    protected void addMany(Collection newRoots) {
        ArrayList allRoots = new ArrayList(this.getContents());
        allRoots.addAll(newRoots);
        Object[] rootArray = allRoots.toArray();
        ((BasicEList)this.getContents()).setData(rootArray.length, rootArray);
        for (EObject eObject : newRoots) {
            if (eObject instanceof EObjectImpl) {
                ((EObjectImpl)eObject).eSetResource((Resource.Internal)this, null);
            }
            this.addToEObjectCache(eObject, true);
        }
    }

    protected void removeMany(Collection roots) {
        ArrayList allRoots = new ArrayList(this.getContents());
        allRoots.removeAll(roots);
        Object[] rootArray = allRoots.toArray();
        ((BasicEList)this.getContents()).setData(rootArray.length, rootArray);
        for (EObject eObject : roots) {
            if (eObject instanceof EObjectImpl) {
                ((EObjectImpl)eObject).eSetResource(null, null);
            }
            this.removeFromEObjectCache(eObject, true);
        }
    }

    protected EObjectCache getEProxyCache() {
        return this.eProxyCache;
    }

    protected void addToEProxyCache(EObject eObject) {
        if (eObject != null) {
            this.getEProxyCache().add(eObject, false);
        }
    }

    protected EObject removeFromEProxyCache(ObjectID id) {
        EObject eObject = this.getEProxyCache().get(id);
        this.getEProxyCache().remove(id, false);
        return eObject;
    }

    protected EObject findInEProxyCache(ObjectID id) {
        return id != null ? this.getEProxyCache().get(id) : null;
    }

    protected EObjectCache getEObjectCache() {
        return this.eObjectCache;
    }

    protected void addToEObjectCache(EObject eObject, boolean recurse) {
        if (eObject != null) {
            this.getEObjectCache().add(eObject, recurse);
        }
    }

    protected EObject removeFromEObjectCache(ObjectID id, boolean recurse) {
        EObject eObject = this.getEObjectCache().get(id);
        this.getEObjectCache().remove(id, recurse);
        return eObject;
    }

    protected void removeFromEObjectCache(EObject eObject, boolean recurse) {
        this.getEObjectCache().remove(eObject, recurse);
    }

    protected EObject findInEObjectCache(ObjectID id) {
        EObject eObject = null;
        if (id != null) {
            eObject = this.getEObjectCache().get(id);
        }
        return eObject;
    }

    @Override
    public String getUuid(EObject object) {
        return null;
    }

    @Override
    public boolean isLoading() {
        return super.isLoading();
    }

    @Override
    public boolean isUnloading() {
        return false;
    }

    @Override
    public void setUuid(EObject object, String uuid) {
        super.setID(object, uuid);
    }

    class EObjectCacheAdapter
    extends AdapterImpl {
        EObjectCacheAdapter() {
        }

        public void notifyChanged(Notification notification) {
            if (notification.isTouch()) {
                return;
            }
            Object feature = notification.getFeature();
            if (feature == null || feature instanceof EReference && ((EReference)feature).isContainment()) {
                int eventType = notification.getEventType();
                Object oldVal = notification.getOldValue();
                Object newVal = notification.getNewValue();
                switch (eventType) {
                    case 4: {
                        if (!(oldVal instanceof EObject)) break;
                        EResourceImpl.this.getEObjectCache().remove((EObject)oldVal, true);
                        break;
                    }
                    case 6: {
                        if (!(oldVal instanceof Collection)) break;
                        EObject[] oldVals = this.collectionToEObjectArray((Collection)oldVal);
                        EResourceImpl.this.getEObjectCache().remove(oldVals, true);
                        break;
                    }
                    case 3: {
                        if (!(newVal instanceof EObject)) break;
                        EResourceImpl.this.getEObjectCache().add((EObject)newVal, true);
                        break;
                    }
                    case 5: {
                        if (!(newVal instanceof Collection)) break;
                        EObject[] newVals = this.collectionToEObjectArray((Collection)newVal);
                        EResourceImpl.this.getEObjectCache().add(newVals, true);
                    }
                }
            }
        }

        private EObject[] collectionToEObjectArray(Collection values) {
            if (values == null || values.isEmpty()) {
                return EMPTY_EOBJECT_ARRAY;
            }
            ArrayList result = new ArrayList(values.size());
            for (Object obj : values) {
                if (!(obj instanceof EObject)) continue;
                result.add(obj);
            }
            return result.toArray(new EObject[result.size()]);
        }
    }

    protected class EResourceContentsEList
    extends ResourceImpl.ContentsEList {
        private static final long serialVersionUID = 1L;
        private final EResourceImpl owner;

        public EResourceContentsEList(EResourceImpl owner) {
            super((ResourceImpl)EResourceImpl.this);
            this.owner = owner;
        }

        public boolean addAll(Collection c) {
            if (c == null || c.isEmpty()) {
                return false;
            }
            ArrayList roots = new ArrayList(c);
            Iterator i = roots.iterator();
            while (i.hasNext()) {
                EObject root = (EObject)i.next();
                if (root != null) continue;
                i.remove();
            }
            int index = this.size;
            this.owner.addMany(roots);
            BasicEList vals = new BasicEList(roots);
            EResourceImpl.this.eNotify((Notification)this.createNotification(5, null, vals, index, true));
            return true;
        }

        public boolean removeAll(Collection c) {
            if (c == null || c.isEmpty()) {
                return false;
            }
            BasicEList vals = new BasicEList(c);
            int[] removedIndexes = this.getIndexes((Collection)vals);
            this.owner.removeMany(c);
            if (vals.size() == 1) {
                EResourceImpl.this.eNotify((Notification)this.createNotification(4, vals.get(0), null, removedIndexes[0]));
            } else {
                EResourceImpl.this.eNotify((Notification)this.createNotification(6, vals, removedIndexes, removedIndexes[0], true));
            }
            return true;
        }

        private int[] getIndexes(Collection vals) {
            BasicEList tmp = new BasicEList((Collection)((Object)this));
            int[] result = new int[vals.size()];
            Iterator it = tmp.iterator();
            int count = 0;
            int index = 0;
            while (it.hasNext()) {
                Object next = it.next();
                if (vals.contains(next)) {
                    result[count++] = index;
                }
                ++index;
            }
            return result;
        }
    }
}

