/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.common.xmi.XMIHeaderReader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.DuplicateResourceException;
import org.teiid.designer.core.resource.BuiltInTypesHrefConverter;
import org.teiid.designer.core.resource.EObjectHrefConverter;
import org.teiid.designer.core.resource.EResource;
import org.teiid.designer.core.resource.EResourceSet;

public class EResourceSetImpl
extends ResourceSetImpl
implements EResourceSet {
    private static final char SEGMENT_SEPARATOR = '/';
    private EObjectHrefConverter eObjectHrefConverter;
    private final List externalResourceSets = new ArrayList(7);
    private final IChangeNotifier changeNotifier = new ChangeNotifier();

    public EResourceSetImpl() {
        this.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                EResourceSetImpl.this.getChangeNotifier().fireNotifyChanged(notification);
            }
        });
    }

    public Map getLoadOptions() {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>(super.getLoadOptions());
        if (options.get("DISABLE_NOTIFY") == null) {
            options.put("DISABLE_NOTIFY", Boolean.TRUE);
        }
        return options;
    }

    public Resource createResource(URI uri) {
        this.canCreateResource(uri);
        return super.createResource(uri);
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        Resource eResource = super.delegatedGetResource(uri, loadOnDemand);
        if (eResource == null) {
            ResourceSet[] eResourceSets = this.getExternalResourceSets();
            int i = 0;
            while (i < eResourceSets.length) {
                eResource = eResourceSets[i].getResource(uri, false);
                if (eResource != null) break;
                ++i;
            }
        }
        return eResource;
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource eResource = super.getResource(uri, loadOnDemand);
        if (eResource == null && uri.toString().charAt(0) == '/') {
            String relativePath = uri.toFileString();
            for (Resource rsrc : this.getResources()) {
                String uriString = rsrc.getURI().toFileString();
                if (!uriString.endsWith(relativePath)) continue;
                return rsrc;
            }
        }
        return eResource;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        EObject eObject;
        URI physicalUri;
        File f;
        URI eResourceURI = uri.trimFragment();
        if (eResourceURI.isFile() && !(f = new File(eResourceURI.toFileString())).exists()) {
            return null;
        }
        URI lookupUri = uri;
        if (this.getEObjectHrefConverter() != null && (physicalUri = this.getEObjectHrefConverter().getPhysicalURI(uri)) != null) {
            lookupUri = physicalUri;
        }
        if ((eObject = super.getEObject(lookupUri, loadOnDemand)) == null) {
            String msg = ModelerCore.Util.getString("EResourceSetImpl.Unresolved_proxy", (Object)lookupUri);
            ModelerCore.Util.log(2, msg);
        }
        return eObject;
    }

    @Override
    public EObjectHrefConverter getEObjectHrefConverter() {
        if (this.eObjectHrefConverter == null) {
            this.eObjectHrefConverter = new BuiltInTypesHrefConverter(this);
        }
        return this.eObjectHrefConverter;
    }

    @Override
    public void setEObjectHrefConverter(EObjectHrefConverter theConverter) {
        this.eObjectHrefConverter = theConverter;
    }

    @Override
    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    @Override
    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void addExternalResourceSet(ResourceSet resourceSet, Map physicalToLogicalUri) {
        if (resourceSet != null && !this.externalResourceSets.contains(resourceSet)) {
            this.externalResourceSets.add(resourceSet);
            if (physicalToLogicalUri != null) {
                for (Map.Entry entry : physicalToLogicalUri.entrySet()) {
                    URI physicalURI = (URI)entry.getKey();
                    URI logicalURI = (URI)entry.getValue();
                    this.getURIConverter().getURIMap().put(logicalURI, physicalURI);
                }
            }
        }
    }

    @Override
    public void addExternalResourceSet(ResourceSet resourceSet) {
        if (resourceSet != null && !this.externalResourceSets.contains(resourceSet)) {
            this.externalResourceSets.add(resourceSet);
        }
    }

    @Override
    public ResourceSet[] getExternalResourceSets() {
        return this.externalResourceSets.toArray(new ResourceSet[this.externalResourceSets.size()]);
    }

    public IChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }

    protected void canCreateResource(URI uri) {
        this.checkForInvalidXmiVersion(uri);
        this.checkForDuplicateUuid(uri);
    }

    protected void checkForDuplicateUuid(URI uri) {
        XMIHeader header = this.doGetXMIHeader(uri);
        if (header != null && header.getUUID() != null) {
            String uuidString = header.getUUID();
            try {
                ObjectID uuid = IDGenerator.getInstance().stringToObject(uuidString);
                for (Resource rsrc : this.getResources()) {
                    if (!(rsrc instanceof EResource) || !uuid.equals(((EResource)rsrc).getUuid())) continue;
                    Object[] params = new Object[]{URI.decode((String)uri.toString()), URI.decode((String)rsrc.getURI().toString())};
                    String msg = ModelerCore.Util.getString("EResourceSetImpl.Duplicate_resource_UUID_encountered", params);
                    throw new DuplicateResourceException(rsrc, null, msg);
                }
            }
            catch (InvalidIDException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
    }

    protected void checkForInvalidXmiVersion(URI uri) {
        XMIHeader header = this.doGetXMIHeader(uri);
        if (header != null && header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
            Object[] params = new Object[]{uri};
            String msg = ModelerCore.Util.getString("EResourceSetImpl.Old_model_format_encountered", params);
            throw new TeiidDesignerRuntimeException(msg);
        }
    }

    protected XMIHeader doGetXMIHeader(URI uri) {
        File f;
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        if (normalizedURI.isFile() && (f = new File(normalizedURI.toFileString())).isFile() && f.exists()) {
            try {
                return XMIHeaderReader.readHeader((File)f);
            }
            catch (TeiidDesignerException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
        return null;
    }
}

