/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.container.ContainerImpl;
import org.teiid.designer.core.container.DuplicateResourceException;
import org.teiid.designer.core.metamodel.MetamodelRegistry;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.resource.EmfResourceSet;
import org.teiid.designer.core.resource.xmi.MtkXmiResourceFactory;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.util.BasicUriPathConverter;
import org.teiid.designer.core.util.UriPathConverter;
import org.teiid.designer.core.workspace.ModelFileUtil;

public class EmfResourceSetImpl
extends ResourceSetImpl
implements EmfResourceSet,
IEditingDomainProvider {
    private final Container container;
    private ResourceSet[] externalResourceSets;
    private UriPathConverter pathConverter;

    public EmfResourceSetImpl(Container container) {
        if (container == null) {
            String msg = ModelerCore.Util.getString("EmfResourceSetImpl.The_Container_reference_may_not_be_null_1", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        this.container = container;
        this.externalResourceSets = new ResourceSet[0];
    }

    public Resource createResource(URI uri) {
        this.canCreateResource(uri);
        return super.createResource(uri);
    }

    protected void canCreateResource(URI uri) {
        String uuidString;
        XMIHeader header = this.doGetXMIHeader(uri);
        if (header != null && (uuidString = header.getUUID()) != null) {
            try {
                ObjectID uuid = IDGenerator.getInstance().stringToObject(uuidString);
                Resource myExistingResource = this.container.getResourceFinder().findByUUID(uuid, false);
                if (myExistingResource != null) {
                    URI existingResourceUri = myExistingResource.getURI();
                    Object[] params = new Object[]{URI.decode((String)uri.toString()), URI.decode((String)existingResourceUri.toString())};
                    String msg = ModelerCore.Util.getString("EmfResourceSetImpl.Unable_to_load_model_at_0_because_same_as_1", params);
                    throw new DuplicateResourceException(myExistingResource, null, msg);
                }
                Object existingObject = this.container.getEObjectFinder().find((Object)uuid);
                if (existingObject != null) {
                    Resource existingResource;
                    if (existingObject instanceof EObject && (existingResource = ((EObject)existingObject).eResource()) != null) {
                        Container cntr;
                        if (existingResource instanceof EmfResource && (cntr = ((EmfResource)existingResource).getContainer()) != this.getContainer()) {
                            return;
                        }
                        ResourceSet set = existingResource.getResourceSet();
                        if (set instanceof EmfResourceSet && set != this) {
                            return;
                        }
                        URI existingResourceUri = existingResource.getURI();
                        Object[] params = new Object[]{URI.decode((String)uri.toString()), URI.decode((String)existingResourceUri.toString())};
                        String msg = ModelerCore.Util.getString("EmfResourceSetImpl.Unable_to_load_model_at_0_because_same_as_1", params);
                        throw new DuplicateResourceException(existingResource, null, msg);
                    }
                    Object[] params = new Object[]{uri};
                    String msg = ModelerCore.Util.getString("EmfResourceSetImpl.Unable_to_load_model_at_0_because_already_loaded", params);
                    throw new DuplicateResourceException(msg);
                }
            }
            catch (InvalidIDException e) {
                ModelerCore.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        MetamodelRegistry registry;
        if (ModelerCore.DEBUG && ModelerCore.DEBUG_METAMODEL) {
            Object[] params = new Object[]{uri, new Boolean(loadOnDemand)};
            ModelerCore.Util.log(1, ModelerCore.Util.getString("EmfResourceSetImpl.DEBUG.EmfResourceSetImpl.delegatedGetResource_for_URI,_loadOnDemand_2", params));
        }
        if ((registry = this.getContainer().getMetamodelRegistry()) != null && registry.containsURI(uri)) {
            Resource resource = registry.getResource(uri);
            if (ModelerCore.DEBUG && ModelerCore.DEBUG_METAMODEL) {
                Object[] params = new Object[]{uri};
                ModelerCore.Util.log(1, ModelerCore.Util.getString("EmfResourceSetImpl.DEBUG.Returning_resource_in_the_MetamodelRegistry_for_URI_3", params));
            }
            return resource;
        }
        int i = 0;
        while (i < this.externalResourceSets.length) {
            ResourceSet resourceSet = this.externalResourceSets[i];
            Resource resource = resourceSet.getResource(uri, false);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return super.delegatedGetResource(uri, loadOnDemand);
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource resource = null;
        URI resourceURI = uri;
        try {
            UnitOfWork txn = this.container.getEmfTransactionProvider().getCurrent();
            boolean alreadyStarted = true;
            if (!txn.isStarted()) {
                txn.begin();
                alreadyStarted = false;
            }
            resource = super.getResource(resourceURI, false);
            boolean canSearchWorkspace = this.canSearchWorkspace();
            if (resource == null && resourceURI.isRelative() && canSearchWorkspace) {
                resourceURI = this.getUriPathConverter().makeAbsolute(resourceURI, null);
                resource = super.getResource(resourceURI, false);
            }
            if (resource == null) {
                this.registerResourceExtension(resourceURI, loadOnDemand);
            }
            if (resource == null || !resource.isLoaded() && loadOnDemand) {
                if (resourceURI.isFile()) {
                    File resourceFile = new File(resourceURI.toFileString());
                    if (resourceFile.exists()) {
                        resource = super.getResource(resourceURI, loadOnDemand);
                    }
                } else {
                    resource = super.getResource(resourceURI, loadOnDemand);
                }
                if (resource != null) {
                    resource.setModified(false);
                }
            }
            if (!alreadyStarted) {
                txn.commit();
            }
        }
        catch (ModelerCoreException t) {
            Object[] params = new Object[]{uri, new Boolean(loadOnDemand)};
            String msg = ModelerCore.Util.getString("EmfResourceSetImpl.Error_in_EmfResourceSetImpl.getResource()_2", params);
            ModelerCore.Util.log(4, (Throwable)t, msg);
        }
        catch (DuplicateResourceException t) {
            throw t;
        }
        catch (RuntimeException t) {
            Object[] params = new Object[]{uri, new Boolean(loadOnDemand)};
            String msg = ModelerCore.Util.getString("EmfResourceSetImpl.Error_in_EmfResourceSetImpl.getResource()_2", params);
            ModelerCore.Util.log(4, (Throwable)t, msg);
            throw t;
        }
        return resource;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        CoreArgCheck.isNotNull((Object)uri);
        if (uri != null) {
            File resourceFile;
            Resource resource;
            URI resourceURI = uri.trimFragment();
            String resourceUriString = resourceURI.toString();
            String uriFragmentString = uri.fragment();
            if ("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance".equals(resourceUriString) || "http://www.w3.org/2001/XMLSchema".equals(resourceUriString)) {
                try {
                    DatatypeManager dtMgr = this.container.getDatatypeManager();
                    if (dtMgr != null) {
                        return dtMgr.findDatatype(uriFragmentString);
                    }
                    Object[] params = new Object[]{uri, this.container};
                    String msg = ModelerCore.Util.getString("EmfResourceSetImpl.Error_in_EmfResourceSetImpl.getResource()_3", params);
                    ModelerCore.Util.log(4, msg);
                }
                catch (ModelerCoreException e1) {
                    ModelerCore.Util.log(4, (Throwable)e1, e1.getMessage());
                }
            }
            if ((resource = this.getResource(resourceURI, false)) != null) {
                resource = this.getResource(resourceURI, loadOnDemand);
                return super.getEObject(uri, loadOnDemand);
            }
            boolean canSearchWorkspace = this.canSearchWorkspace();
            if (resourceURI.isRelative() && canSearchWorkspace && (resource = super.getResource(resourceURI = this.getUriPathConverter().makeAbsolute(resourceURI, null), false)) != null) {
                return resource.getEObject(uriFragmentString);
            }
            if (resourceURI.isFile() && !(resourceFile = new File(resourceURI.toFileString())).exists()) {
                return null;
            }
            try {
                resource = super.getResource(resourceURI, loadOnDemand);
                if (resource != null) {
                    return resource.getEObject(uriFragmentString);
                }
            }
            catch (Throwable throwable) {
                resource = this.getResource(resourceURI, false);
                if (resource != null) {
                    this.getResources().remove((Object)resource);
                }
                return null;
            }
        }
        return super.getEObject(uri, loadOnDemand);
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    public EditingDomain getEditingDomain() {
        return ((ContainerImpl)this.container).getEditingDomain();
    }

    public void addExternalResourceSet(ResourceSet resourceSet) {
        if (resourceSet != null) {
            ArrayList<ResourceSet> tmp = new ArrayList<ResourceSet>();
            tmp.addAll(Arrays.asList(this.externalResourceSets));
            tmp.add(resourceSet);
            this.externalResourceSets = new ResourceSet[tmp.size()];
            tmp.toArray(this.externalResourceSets);
        }
    }

    public ResourceSet[] getExternalResourceSets() {
        return this.externalResourceSets;
    }

    public Map getLoadOptions() {
        HashMap options = new HashMap(super.getLoadOptions());
        Map cntrOptions = this.container.getOptions();
        if (cntrOptions.containsKey("XML_MAP")) {
            options.put("XML_MAP", cntrOptions.get("XML_MAP"));
        }
        return options;
    }

    public UriPathConverter getUriPathConverter() {
        if (this.pathConverter == null) {
            this.pathConverter = new BasicUriPathConverter();
        }
        return this.pathConverter;
    }

    public void setUriPathConverter(UriPathConverter converter) {
        this.pathConverter = converter;
    }

    protected void registerResourceExtension(URI uri, boolean loadOnDemand) {
        if (uri != null && loadOnDemand) {
            String extension = uri.fileExtension();
            Resource.Factory.Registry registry = super.getResourceFactoryRegistry();
            Map extensionToFactoryMap = registry.getExtensionToFactoryMap();
            if (extensionToFactoryMap.get(extension) != null) {
                return;
            }
            XMIHeader header = this.doGetXMIHeader(uri);
            if (header != null) {
                if (header.getXmiVersion() != null && header.getXmiVersion().startsWith("1.")) {
                    return;
                }
                if (header.getUUID() != null) {
                    Resource.Factory factory = (Resource.Factory)extensionToFactoryMap.get("xmi");
                    if (factory != null) {
                        extensionToFactoryMap.put(extension, factory);
                    } else {
                        extensionToFactoryMap.put(extension, new MtkXmiResourceFactory());
                    }
                }
            }
        }
    }

    protected XMIHeader doGetXMIHeader(URI uri) {
        File resource;
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        if (normalizedURI.isFile() && normalizedURI.hasAbsolutePath() && (resource = new File(normalizedURI.toFileString())).exists()) {
            XMIHeader header = ModelFileUtil.getXmiHeader((File)resource);
            return header;
        }
        return null;
    }

    protected boolean canSearchWorkspace() {
        return ModelerCore.isModelContainer(this.getContainer());
    }
}

