/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.resource;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.teiid.core.designer.id.IDGenerator;
import org.teiid.designer.core.resource.XmlXResourceDelegate;
import org.teiid.designer.core.resource.xmi.MtkXmiResourceImpl;

public final class XResourceDelegate
extends XmlXResourceDelegate {
    private Map<String, EObject> uuidToEObjectMap = new HashMap<String, EObject>();
    private Map<EObject, String> eObjectToUuidMap = new HashMap<EObject, String>();

    public void attachedHelper(EObject eObject) {
        String uuid = this.eObjectToUuidMap.get(eObject);
        if (uuid == null) {
            uuid = MtkXmiResourceImpl.DETACHED_EOBJECT_TO_UUID_MAP.remove(eObject);
            if (uuid == null) {
                uuid = IDGenerator.getInstance().create().toString();
            } else {
                MtkXmiResourceImpl.DETACHED_UUID_TO_EOBJECT_MAP.remove(uuid);
            }
            this.setUuid(eObject, uuid);
        } else {
            this.uuidToEObjectMap.put(uuid, eObject);
        }
    }

    @Override
    public void attachedHelper(XMLResource resource, EObject object) {
        throw new UnsupportedOperationException();
    }

    public void detachedHelper(EObject eObject) {
        String uuid = this.getUuid(eObject);
        MtkXmiResourceImpl.DETACHED_EOBJECT_TO_UUID_MAP.put(eObject, uuid);
        MtkXmiResourceImpl.DETACHED_UUID_TO_EOBJECT_MAP.put(uuid, eObject);
        this.setUuid(eObject, null);
    }

    @Override
    public void detachedHelper(XMLResource resource, EObject object) {
        throw new UnsupportedOperationException();
    }

    public void doUnload() {
        this.eObjectToUuidMap.clear();
        this.uuidToEObjectMap.clear();
    }

    public EObject getEObjectById(String uuid) {
        return this.uuidToEObjectMap.get(uuid);
    }

    public String getUuid(EObject eObject) {
        return this.eObjectToUuidMap.get(eObject);
    }

    @Override
    public void initialize(XMLResource resource) {
        throw new UnsupportedOperationException();
    }

    public void setUuid(EObject eObject, String uuid) {
        String oldUuid;
        String string = oldUuid = uuid != null ? this.eObjectToUuidMap.put(eObject, uuid) : this.eObjectToUuidMap.remove(eObject);
        if (oldUuid != null) {
            this.uuidToEObjectMap.remove(oldUuid);
        }
        if (uuid != null) {
            this.uuidToEObjectMap.put(uuid, eObject);
        }
    }

    public String toKeyString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().toString());
        if (this.uuidToEObjectMap != null) {
            TreeMap<String, String> tree = new TreeMap<String, String>();
            for (String key : this.uuidToEObjectMap.keySet()) {
                if (key == null) continue;
                tree.put(key, key);
            }
            for (String key : tree.values()) {
                EObject value = this.uuidToEObjectMap.get(key);
                result.append("\r\n\t[").append(key).append("=").append(value).append("]");
            }
        }
        return result.toString();
    }
}

