/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.search.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.IndexConstants;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.index.ModelWorkspaceSearchIndexSelector;
import org.teiid.designer.core.search.MetadataSearch;
import org.teiid.designer.core.search.commands.FindObjectCommand;
import org.teiid.designer.core.search.runtime.ResourceObjectRecord;
import org.teiid.designer.core.search.runtime.SearchRecord;
import org.teiid.designer.core.search.runtime.SearchRuntimeAdapter;
import org.teiid.designer.core.search.runtime.TypedObjectRecord;

public class FindObjectCommandImpl
implements FindObjectCommand {
    private EClass metaClass = null;
    private String featureName = null;
    private String textPattern = null;
    private boolean containsPattern = true;
    private Collection recordInfos = Collections.EMPTY_LIST;
    private IndexSelector selector = null;

    @Override
    public Collection getRecordInfo() {
        return this.recordInfos;
    }

    @Override
    public void setFeatureCriteria(String featureName, String textPattern, boolean containsPattern) {
        this.featureName = featureName;
        this.textPattern = textPattern;
        this.containsPattern = containsPattern;
    }

    @Override
    public void setMetaClass(EClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }

    @Override
    public boolean canExecute() {
        return this.isMetaclassSearch() || this.isFeatureSearch();
    }

    private IStatus executeObjectUriSearch() {
        Status result = null;
        try {
            Object obj = ModelerCore.getModelContainer().getEObjectFinder().find((Object)this.textPattern);
            if (obj != null && obj instanceof EObject) {
                this.recordInfos = Collections.singletonList(SearchRuntimeAdapter.createResourceObjectRecord((EObject)obj));
            }
            result = new Status(0, "org.teiid.designer.core", 0, "", null);
        }
        catch (CoreException theException) {
            ModelerCore.Util.log((Throwable)theException);
            String msg = ModelerCore.Util.getString("FindObjectCommandImpl.objectUriSearchError", (Object)this.textPattern);
            return new Status(4, "org.teiid.designer.core", 0, msg, (Throwable)theException);
        }
        return result;
    }

    @Override
    public IStatus execute() {
        if (!this.canExecute()) {
            return null;
        }
        if (this.isFeatureSearch() && this.featureName.equals(MetadataSearch.OBJECT_URI_FEATURE)) {
            return this.executeObjectUriSearch();
        }
        try {
            String metaclassUri = FindObjectCommandImpl.getMetaclassUri(this.metaClass);
            String matchPattern = this.getMatchPattern(this.featureName, this.textPattern, metaclassUri);
            IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), matchPattern.toCharArray(), '\u00a0');
            this.recordInfos = new ArrayList(results.length);
            int i = 0;
            while (i < results.length) {
                IEntryResult result = results[i];
                this.recordInfos.add(SearchRuntimeAdapter.getSearchRecord(result.getWord()));
                ++i;
            }
            if (this.isFeatureSearch() && !this.containsPattern) {
                matchPattern = this.featureName.equals(MetadataSearch.DESCRIPTION_SEARCH_FEATURE) ? this.getMatchPattern(MetadataSearch.NAME_SEARCH_FEATURE, MetadataSearch.TEXT_PATTERN_ANY_STRING, metaclassUri) : this.getMatchPattern(this.featureName, IndexConstants.RECORD_STRING.MATCH_CHAR_STRING, metaclassUri);
                results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), matchPattern.toCharArray(), '\u00a0');
                HashMap<String, SearchRecord> tmp = new HashMap<String, SearchRecord>(results.length);
                int i2 = 0;
                while (i2 < results.length) {
                    IEntryResult result = results[i2];
                    SearchRecord record = SearchRuntimeAdapter.getSearchRecord(result.getWord());
                    String mapKey = this.getMapKey(record);
                    if (mapKey != null) {
                        tmp.put(mapKey, record);
                    }
                    ++i2;
                }
                for (SearchRecord record : this.recordInfos) {
                    String mapKey = this.getMapKey(record);
                    if (!tmp.containsKey(mapKey)) continue;
                    tmp.remove(mapKey);
                }
                this.recordInfos = tmp.values();
            }
        }
        catch (Exception e) {
            ModelerCore.Util.log((Throwable)e);
            String msg = ModelerCore.Util.getString("FindObjectCommandImpl.Error_trying_to_execute_command", new Object[0]);
            return new Status(4, "org.teiid.designer.core", 0, msg, (Throwable)e);
        }
        return new Status(0, "org.teiid.designer.core", 0, "", null);
    }

    private String getMatchPattern(String feature, String text, String metaClassUri) {
        String pattern = null;
        if (feature != null && feature.equals(MetadataSearch.DESCRIPTION_SEARCH_FEATURE)) {
            String descCriteria = text != null && text.length() != 0 ? text.toUpperCase() : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            String metaclassCriteria = metaClassUri != null && metaClassUri.length() != 0 ? metaClassUri : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            pattern = "J\u00a0" + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + descCriteria + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + metaclassCriteria + '\u00a0';
        } else {
            String nameCriteria = IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            if (feature != null && feature.equals(MetadataSearch.NAME_SEARCH_FEATURE)) {
                nameCriteria = text != null && text.length() != 0 ? text.toUpperCase() : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            }
            String uuidCriteria = IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            if (feature != null && feature.equals(MetadataSearch.UUID_SEARCH_FEATURE)) {
                uuidCriteria = text != null && text.length() != 0 ? text : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            }
            String metaclassCriteria = metaClassUri != null && metaClassUri.length() != 0 ? metaClassUri : IndexConstants.RECORD_STRING.MATCH_CHAR_STRING;
            pattern = "C\u00a0" + uuidCriteria + '\u00a0' + nameCriteria + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + IndexConstants.RECORD_STRING.MATCH_CHAR_STRING + '\u00a0' + metaclassCriteria + '\u00a0';
        }
        return pattern;
    }

    private boolean isFeatureSearch() {
        return this.featureName != null && this.textPattern != null && this.textPattern.length() > 0;
    }

    private boolean isMetaclassSearch() {
        return this.metaClass != null;
    }

    private IndexSelector getIndexSelector() {
        this.selector = this.selector != null ? this.selector : new ModelWorkspaceSearchIndexSelector();
        return this.selector;
    }

    private static String getMetaclassUri(EClass eClass) {
        if (eClass != null) {
            return ModelerCore.getModelEditor().getUri((EObject)eClass).toString();
        }
        return null;
    }

    private String getMapKey(SearchRecord record) {
        if (record != null) {
            String key = record.getUUID();
            if (key != null) {
                return key;
            }
            if (record instanceof ResourceObjectRecord) {
                key = ((ResourceObjectRecord)record).getObjectURI();
                return key;
            }
            if (record instanceof TypedObjectRecord) {
                key = ((TypedObjectRecord)record).getObjectURI();
                return key;
            }
        }
        return null;
    }
}

