/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.search.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.index.IEntryResult;
import org.teiid.designer.core.index.IndexSelector;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.index.ModelWorkspaceSearchIndexSelector;
import org.teiid.designer.core.search.commands.FindRelatedObjectsCommand;
import org.teiid.designer.core.search.runtime.SearchRuntimeAdapter;

public class FindRelatedObjectsCommandImpl
implements FindRelatedObjectsCommand {
    private String modelObjectUri;
    private Collection relatedObjInfo;
    private IndexSelector selector;

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public IStatus execute() {
        String objectUUID = null;
        if (!CoreStringUtil.isEmpty((String)this.modelObjectUri)) {
            URI objectUri = URI.createURI((String)this.modelObjectUri);
            objectUUID = objectUri.fragment();
            objectUUID = objectUUID.replace('/', ':');
        }
        String searchPrefix = IndexUtil.getPrefixPattern('F', objectUUID);
        try {
            IEntryResult[] results = IndexUtil.queryIndex(this.getIndexSelector().getIndexes(), searchPrefix.toCharArray(), true, true);
            this.relatedObjInfo = new ArrayList(results.length);
            int i = 0;
            while (i < results.length) {
                IEntryResult result = results[i];
                this.relatedObjInfo.add(SearchRuntimeAdapter.createRelatedObjectRecord(result.getWord()));
                ++i;
            }
        }
        catch (Exception e) {
            ModelerCore.Util.log((Throwable)e);
            return new Status(4, "org.teiid.designer.core", 0, ModelerCore.Util.getString("FindRelatedObjectsCommandImpl.Error_trying_to_execute_command,_problem_trying_to_query_relationship_search_indexes._1", new Object[0]), (Throwable)e);
        }
        return new Status(0, "org.teiid.designer.core", 0, "", null);
    }

    @Override
    public Collection getRelatedObjectInfo() {
        if (this.relatedObjInfo == null) {
            return Collections.EMPTY_LIST;
        }
        return this.relatedObjInfo;
    }

    @Override
    public void setModelObjectUri(String object) {
        CoreArgCheck.isNotEmpty((String)object);
        this.modelObjectUri = object;
    }

    private IndexSelector getIndexSelector() {
        this.selector = this.selector != null ? this.selector : new ModelWorkspaceSearchIndexSelector();
        return this.selector;
    }

    @Override
    public void setIndexSelector(IndexSelector selector) {
        this.selector = selector;
    }
}

