/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.search.runtime;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metadata.runtime.RuntimeAdapter;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.ImportsAspect;
import org.teiid.designer.core.metamodel.aspect.relationship.RelationshipAspect;
import org.teiid.designer.core.metamodel.aspect.relationship.RelationshipMetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.relationship.RelationshipTypeAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAnnotationAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.search.runtime.AnnotatedObjectRecord;
import org.teiid.designer.core.search.runtime.AnnotatedObjectRecordImpl;
import org.teiid.designer.core.search.runtime.ReferencesRecord;
import org.teiid.designer.core.search.runtime.ReferencesRecordImpl;
import org.teiid.designer.core.search.runtime.RelatedObjectRecord;
import org.teiid.designer.core.search.runtime.RelatedObjectRecordImpl;
import org.teiid.designer.core.search.runtime.RelationshipRecord;
import org.teiid.designer.core.search.runtime.RelationshipRecordImpl;
import org.teiid.designer.core.search.runtime.RelationshipTypeRecord;
import org.teiid.designer.core.search.runtime.RelationshipTypeRecordImpl;
import org.teiid.designer.core.search.runtime.ResourceImportRecord;
import org.teiid.designer.core.search.runtime.ResourceImportRecordImpl;
import org.teiid.designer.core.search.runtime.ResourceObjectRecord;
import org.teiid.designer.core.search.runtime.ResourceObjectRecordImpl;
import org.teiid.designer.core.search.runtime.ResourceRecord;
import org.teiid.designer.core.search.runtime.ResourceRecordImpl;
import org.teiid.designer.core.search.runtime.SearchRecord;
import org.teiid.designer.core.search.runtime.TypedObjectRecord;
import org.teiid.designer.core.search.runtime.TypedObjectRecordImpl;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.metamodels.core.ModelImport;

public class SearchRuntimeAdapter
extends RuntimeAdapter {
    public static void addObjectSearchWords(EObject eObject, String modelPath, List wordEntries) {
        SearchRuntimeAdapter.addEObjectSearchWords(eObject, modelPath, wordEntries);
        SearchRuntimeAdapter.addTypedObjectSearchWords(eObject, modelPath, wordEntries);
        SearchRuntimeAdapter.addAnnotatedObjectSearchWords(eObject, modelPath, wordEntries);
        SearchRuntimeAdapter.addModelImportsSearchWords(eObject, modelPath, wordEntries);
        SearchRuntimeAdapter.addUniDirectionalReferencesSearchWords(eObject, wordEntries);
        SearchRuntimeAdapter.addRelationshipIndexWords(eObject, modelPath, wordEntries);
    }

    public static void addTypedObjectSearchWords(EObject eObject, String modelPath, Collection wordEntries) {
        if (eObject == null) {
            return;
        }
        EClass eClass = eObject.eClass();
        ModelEditor editor = ModelerCore.getModelEditor();
        for (EReference eRef : eClass.getEReferences()) {
            Object value;
            if (!editor.isDatatypeFeature(eObject, (EStructuralFeature)eRef) || (value = eObject.eGet((EStructuralFeature)eRef)) == null) continue;
            if (value instanceof EObject) {
                EObject datatype = (EObject)value;
                StringBuffer sb = new StringBuffer(SearchRuntimeAdapter.getIniitalBufferSize());
                String objectID = SearchRuntimeAdapter.createTypedObjectSearchWord(eObject, datatype, modelPath, sb);
                SearchRuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
                continue;
            }
            if (!(value instanceof List)) continue;
            Object[] values = ((List)value).toArray();
            int i = 0;
            while (i != values.length) {
                Object obj = values[i];
                if (obj instanceof EObject) {
                    EObject datatype = (EObject)obj;
                    StringBuffer sb = new StringBuffer(SearchRuntimeAdapter.getIniitalBufferSize());
                    String objectID = SearchRuntimeAdapter.createTypedObjectSearchWord(eObject, datatype, modelPath, sb);
                    SearchRuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
                }
                ++i;
            }
        }
    }

    private static String createTypedObjectSearchWord(EObject eObject, EObject datatype, String modelPath, StringBuffer sb) {
        ModelEditor editor = ModelerCore.getModelEditor();
        sb.append('I');
        sb.append('\u00a0');
        String objectID = SearchRuntimeAdapter.getObjectIdString(eObject);
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        SqlAspect sqlAspect = AspectManager.getSqlAspect(eObject);
        String name = sqlAspect != null ? sqlAspect.getName(eObject) : editor.getName(eObject);
        SearchRuntimeAdapter.appendObject(name, sb);
        sb.append('\u00a0');
        String fullname = sqlAspect != null ? sqlAspect.getFullName(eObject) : name;
        SearchRuntimeAdapter.appendObject(fullname, sb);
        sb.append('\u00a0');
        URI uri = editor.getUri(eObject);
        SearchRuntimeAdapter.appendObject(uri, sb);
        sb.append('\u00a0');
        SqlDatatypeAspect dtSqlAspect = (SqlDatatypeAspect)AspectManager.getSqlAspect(datatype);
        name = dtSqlAspect != null ? dtSqlAspect.getName(datatype) : editor.getName(datatype);
        SearchRuntimeAdapter.appendObject(name, sb);
        sb.append('\u00a0');
        objectID = dtSqlAspect != null ? dtSqlAspect.getUuidString(datatype) : SearchRuntimeAdapter.getObjectIdString(datatype);
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        String runtimeType = dtSqlAspect != null ? dtSqlAspect.getRuntimeTypeName(datatype) : null;
        SearchRuntimeAdapter.appendObject(runtimeType, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(modelPath, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendURI(eObject.eClass(), sb, true);
        sb.append('\u00a0');
        return objectID;
    }

    public static void addEObjectSearchWords(EObject eObject, String modelPath, Collection wordEntries) {
        String objectID = SearchRuntimeAdapter.getObjectIdString(eObject);
        SqlAspect sqlAspect = AspectManager.getSqlAspect(eObject);
        String name = sqlAspect != null ? sqlAspect.getName(eObject) : ModelerCore.getModelEditor().getName(eObject);
        String fullname = sqlAspect != null ? sqlAspect.getFullName(eObject) : null;
        URI uri = ModelerCore.getModelEditor().getUri(eObject);
        EClass metaClass = eObject.eClass();
        SearchRuntimeAdapter.addEObjectSearchWords(objectID, name, fullname, uri, modelPath, metaClass, wordEntries);
        if (eObject instanceof XSDSimpleTypeDefinition && objectID.startsWith("mmuuid")) {
            if (eObject.eIsProxy()) {
                URI proxyURI = EcoreUtil.getURI((EObject)eObject);
                if (proxyURI != null) {
                    objectID = proxyURI.fragment();
                }
            } else {
                objectID = eObject.eResource().getURIFragment(eObject);
            }
            SearchRuntimeAdapter.addEObjectSearchWords(objectID, name, fullname, uri, modelPath, metaClass, wordEntries);
        }
    }

    public static void addEObjectSearchWords(String objectID, String name, String fullname, URI uri, String modelPath, EClass metaClass, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(SearchRuntimeAdapter.getIniitalBufferSize());
        sb.append('C');
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        String upperName = name != null ? name.toUpperCase() : null;
        SearchRuntimeAdapter.appendObject(upperName, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(name, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(fullname, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(uri, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(modelPath, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendURI(metaClass, sb, true);
        sb.append('\u00a0');
        SearchRuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addAnnotatedObjectSearchWords(EObject eObject, String modelPath, Collection wordEntries) {
        SqlAspect sqlAspect = AspectManager.getSqlAspect(eObject);
        if (sqlAspect != null && sqlAspect instanceof SqlAnnotationAspect) {
            SqlAnnotationAspect sqlAnnotationAspect = (SqlAnnotationAspect)sqlAspect;
            StringBuffer sb = new StringBuffer(SearchRuntimeAdapter.getIniitalBufferSize());
            sb.append('J');
            sb.append('\u00a0');
            String objectID = SearchRuntimeAdapter.getObjectIdString(sqlAnnotationAspect.getObjectID(eObject));
            SearchRuntimeAdapter.appendID(objectID, sb);
            sb.append('\u00a0');
            String name = sqlAnnotationAspect.getName(eObject);
            SearchRuntimeAdapter.appendObject(name, sb);
            sb.append('\u00a0');
            String fullname = sqlAnnotationAspect.getFullName(eObject);
            SearchRuntimeAdapter.appendObject(fullname, sb);
            sb.append('\u00a0');
            URI uri = sqlAnnotationAspect.getURI(eObject);
            SearchRuntimeAdapter.appendObject(uri, sb);
            sb.append('\u00a0');
            Map tags = sqlAnnotationAspect.getTags(eObject);
            SearchRuntimeAdapter.appendStrings(tags, 31, sb);
            sb.append('\u00a0');
            String description = sqlAnnotationAspect.getDescription(eObject);
            if (description != null) {
                description = description.toUpperCase();
            }
            SearchRuntimeAdapter.appendObject(description, sb);
            sb.append('\u00a0');
            SearchRuntimeAdapter.appendObject(modelPath, sb);
            sb.append('\u00a0');
            SearchRuntimeAdapter.appendURI(sqlAnnotationAspect.getMetaclassURI(eObject), sb, false);
            sb.append('\u00a0');
            SearchRuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
        }
    }

    public static void addUniDirectionalReferencesSearchWords(EObject eObject, Collection wordEntries) {
        EClass eClass = eObject.eClass();
        EList references = eClass.getEAllReferences();
        for (EReference reference : references) {
            Object value;
            if (reference.isContainment() || reference.isVolatile() || !reference.isChangeable() || reference.getEOpposite() != null || (value = eObject.eGet((EStructuralFeature)reference)) == null) continue;
            if (reference.isMany()) {
                Iterator valIter = ((EList)value).iterator();
                while (valIter.hasNext()) {
                    SearchRuntimeAdapter.addUniDirectionalReferenceWord(eObject, (EObject)valIter.next(), wordEntries);
                }
                continue;
            }
            SearchRuntimeAdapter.addUniDirectionalReferenceWord(eObject, (EObject)value, wordEntries);
        }
    }

    public static void addUniDirectionalReferenceWord(EObject eObject, EObject referencedObj, Collection wordEntries) {
        if (referencedObj == null || referencedObj.eResource() == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(SearchRuntimeAdapter.getIniitalBufferSize());
        sb.append('D');
        sb.append('\u00a0');
        String objectID = SearchRuntimeAdapter.getObjectIdString(referencedObj);
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(eObject, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.addNewWordEntryToList(objectID, sb, wordEntries);
    }

    public static void addResourceSearchWords(Object resourceUUID, IPath resourcePath, Object resourceURI, String metamodelURI, String modelType, Collection wordEntries) {
        if (resourceUUID == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(SearchRuntimeAdapter.getIniitalBufferSize());
        sb.append('A');
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(resourceUUID, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(resourcePath, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(resourceURI, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(metamodelURI, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(modelType, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.addNewWordEntryToList(resourceUUID.toString(), sb, wordEntries);
    }

    public static void addModelImportsSearchWords(EObject eObject, String modelPath, Collection wordEntries) {
        ModelResource mdlResource;
        ImportsAspect importAspect = AspectManager.getModelImportsAspect(eObject);
        if (importAspect == null) {
            return;
        }
        IPath path = importAspect.getModelPath(eObject);
        if (path == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(SearchRuntimeAdapter.getIniitalBufferSize());
        sb.append('B');
        sb.append('\u00a0');
        sb.append(path);
        sb.append('\u00a0');
        String resourceUUID = importAspect.getModelUuid(eObject);
        if (resourceUUID == null && eObject instanceof ModelImport && (mdlResource = ModelerCore.getModelEditor().findModelResource((ModelImport)eObject)) != null) {
            try {
                resourceUUID = mdlResource.getUuid();
            }
            catch (Exception e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
        SearchRuntimeAdapter.appendObject(resourceUUID, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendObject(modelPath, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.addNewWordEntryToList(resourceUUID, sb, wordEntries);
    }

    public static void addRelationshipIndexWords(Object eObject, String modelPath, Collection wordEntries) {
        RelationshipMetamodelAspect relAspect = AspectManager.getRelationshipAspect((EObject)eObject);
        if (relAspect == null) {
            return;
        }
        if (relAspect.isRecordType('F')) {
            SearchRuntimeAdapter.addRelatedObjectWords((RelationshipAspect)relAspect, (EObject)eObject, wordEntries);
        }
        if (relAspect.isRecordType('E')) {
            SearchRuntimeAdapter.addRelationshipWord((RelationshipAspect)relAspect, modelPath, (EObject)eObject, wordEntries);
        }
        if (relAspect.isRecordType('G')) {
            SearchRuntimeAdapter.addRelationshipTypeWord((RelationshipTypeAspect)relAspect, (EObject)eObject, wordEntries);
        }
    }

    public static void addRelationshipWord(RelationshipAspect relationAspect, String modelPath, EObject eObject, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(SearchRuntimeAdapter.getIniitalBufferSize());
        sb.append('E');
        sb.append('\u00a0');
        Object objectID = relationAspect.getObjectID(eObject);
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        String name = relationAspect.getName(eObject);
        String upperName = name != null ? name.toUpperCase() : null;
        SearchRuntimeAdapter.appendID(name, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(upperName, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getType(eObject), sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getTypeName(eObject), sb);
        sb.append('\u00a0');
        URI uri = eObject != null ? EcoreUtil.getURI((EObject)eObject) : null;
        SearchRuntimeAdapter.appendObject(uri, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(modelPath, sb);
        sb.append('\u00a0');
        String stringID = objectID != null ? objectID.toString() : " ";
        SearchRuntimeAdapter.addNewWordEntryToList(stringID, sb, wordEntries);
    }

    public static void addRelationshipTypeWord(RelationshipTypeAspect relationAspect, EObject eObject, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(SearchRuntimeAdapter.getIniitalBufferSize());
        sb.append('G');
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getName(eObject), sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getSuperType(eObject), sb);
        sb.append('\u00a0');
        Object objectID = relationAspect.getObjectID(eObject);
        SearchRuntimeAdapter.appendID(objectID, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getSourceRoleName(eObject), sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationAspect.getTargetRoleName(eObject), sb);
        sb.append('\u00a0');
        URI uri = eObject != null ? EcoreUtil.getURI((EObject)eObject) : null;
        SearchRuntimeAdapter.appendObject(uri, sb);
        sb.append('\u00a0');
        String relationTypeID = objectID != null ? objectID.toString() : " ";
        SearchRuntimeAdapter.addNewWordEntryToList(relationTypeID, sb, wordEntries);
    }

    public static void addRelatedObjectWords(RelationshipAspect relationAspect, EObject relObject, Collection wordEntries) {
        for (Object srcObj : relationAspect.getSources(relObject)) {
            for (Object tgtObj : relationAspect.getTargets(relObject)) {
                SearchRuntimeAdapter.addRelatedObjectWord(srcObj, tgtObj, relationAspect, relObject, true, wordEntries);
                SearchRuntimeAdapter.addRelatedObjectWord(tgtObj, srcObj, relationAspect, relObject, false, wordEntries);
            }
        }
    }

    public static void addRelatedObjectWord(Object eObject, Object relatedObj, RelationshipAspect relationAspect, EObject relationObj, boolean isSource, Collection wordEntries) {
        StringBuffer sb = new StringBuffer(SearchRuntimeAdapter.getIniitalBufferSize());
        sb.append('F');
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(eObject, sb);
        sb.append('\u00a0');
        String relatedObjectID = SearchRuntimeAdapter.getObjectIdString(relatedObj);
        SearchRuntimeAdapter.appendID(relatedObj, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendID(relationObj, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.appendBoolean(isSource, sb);
        sb.append('\u00a0');
        String metaClassURI = null;
        if (relatedObj instanceof EObject) {
            metaClassURI = ModelerCore.getMetamodelRegistry().getMetaClassURI(((EObject)eObject).eClass());
        }
        SearchRuntimeAdapter.appendObject(metaClassURI, sb);
        sb.append('\u00a0');
        String relatedClassURI = null;
        if (relatedObj instanceof EObject) {
            relatedClassURI = ModelerCore.getMetamodelRegistry().getMetaClassURI(((EObject)relatedObj).eClass());
        }
        SearchRuntimeAdapter.appendObject(relatedClassURI, sb);
        sb.append('\u00a0');
        String sourceRoleName = relationAspect.getSourceRoleName(relationObj);
        String targetRoleName = relationAspect.getTargetRoleName(relationObj);
        if (isSource) {
            SearchRuntimeAdapter.appendObject(sourceRoleName, sb);
            sb.append('\u00a0');
            SearchRuntimeAdapter.appendObject(targetRoleName, sb);
            sb.append('\u00a0');
        } else {
            SearchRuntimeAdapter.appendObject(targetRoleName, sb);
            sb.append('\u00a0');
            SearchRuntimeAdapter.appendObject(sourceRoleName, sb);
            sb.append('\u00a0');
        }
        String name = eObject instanceof EObject ? SearchRuntimeAdapter.getName((EObject)eObject) : null;
        SearchRuntimeAdapter.appendObject(name, sb);
        sb.append('\u00a0');
        String relatedName = eObject instanceof EObject ? SearchRuntimeAdapter.getName((EObject)relatedObj) : null;
        SearchRuntimeAdapter.appendObject(relatedName, sb);
        sb.append('\u00a0');
        URI uri = eObject instanceof EObject ? EcoreUtil.getURI((EObject)((EObject)eObject)) : null;
        SearchRuntimeAdapter.appendObject(uri, sb);
        sb.append('\u00a0');
        URI relatedUri = eObject instanceof EObject ? EcoreUtil.getURI((EObject)((EObject)relatedObj)) : null;
        SearchRuntimeAdapter.appendObject(relatedUri, sb);
        sb.append('\u00a0');
        ModelEditor editor = ModelerCore.getModelEditor();
        ModelResource modelRsc = eObject instanceof EObject ? editor.findModelResource((EObject)eObject) : null;
        String resourcePath = null;
        if (modelRsc != null) {
            resourcePath = modelRsc.getPath().toString();
        }
        SearchRuntimeAdapter.appendObject(resourcePath, sb);
        sb.append('\u00a0');
        ModelResource relatedModelRsc = eObject instanceof EObject ? editor.findModelResource((EObject)relatedObj) : null;
        String relatedResourcePath = null;
        if (relatedModelRsc != null) {
            relatedResourcePath = relatedModelRsc.getPath().toString();
        }
        SearchRuntimeAdapter.appendObject(relatedResourcePath, sb);
        sb.append('\u00a0');
        SearchRuntimeAdapter.addNewWordEntryToList(relatedObjectID, sb, wordEntries);
    }

    private static String getName(EObject eObject) {
        IItemLabelProvider provider;
        AdapterFactory adapterFactory = ModelerCore.getMetamodelRegistry().getAdapterFactory();
        if (adapterFactory != null && (provider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
            return provider.getText((Object)eObject);
        }
        return null;
    }

    public static SearchRecord getSearchRecord(char[] record) {
        if (record == null || record.length == 0) {
            return null;
        }
        switch (record[0]) {
            case 'E': {
                return SearchRuntimeAdapter.createRelationshipRecord(record);
            }
            case 'F': {
                return SearchRuntimeAdapter.createRelatedObjectRecord(record);
            }
            case 'G': {
                return SearchRuntimeAdapter.createRelationshipTypeRecord(record);
            }
            case 'H': {
                return null;
            }
            case 'A': {
                return SearchRuntimeAdapter.createResourceRecord(record);
            }
            case 'C': {
                return SearchRuntimeAdapter.createResourceObjectRecord(record);
            }
            case 'D': {
                return SearchRuntimeAdapter.createResourceObjRefRecord(record);
            }
            case 'B': {
                return SearchRuntimeAdapter.createResourceImportRecord(record);
            }
            case 'I': {
                return SearchRuntimeAdapter.createTypedObjectRecord(record);
            }
            case 'J': {
                return SearchRuntimeAdapter.createAnnotatedObjectRecord(record);
            }
        }
        throw new IllegalArgumentException(ModelerCore.Util.getString("RelationshipRuntimeAdapter.Invalid_relationship_search_record_type_{0}_for_creating_RelationshipSearchRecord._1", (Object)Character.valueOf(record[0])));
    }

    public static ResourceObjectRecord createResourceObjectRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ResourceObjectRecordImpl objRecord = new ResourceObjectRecordImpl();
        int tokenIndex = 1;
        objRecord.setUUID((String)tokens.get(tokenIndex++));
        objRecord.setName((String)tokens.get(tokenIndex++));
        objRecord.setName((String)tokens.get(tokenIndex++));
        objRecord.setFullname((String)tokens.get(tokenIndex++));
        objRecord.setObjectURI((String)tokens.get(tokenIndex++));
        objRecord.setResourcePath((String)tokens.get(tokenIndex++));
        objRecord.setMetaclassURI((String)tokens.get(tokenIndex++));
        return objRecord;
    }

    public static TypedObjectRecord createTypedObjectRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        TypedObjectRecordImpl objRecord = new TypedObjectRecordImpl();
        int tokenIndex = 1;
        objRecord.setUUID((String)tokens.get(tokenIndex++));
        objRecord.setName((String)tokens.get(tokenIndex++));
        objRecord.setFullname((String)tokens.get(tokenIndex++));
        objRecord.setObjectURI((String)tokens.get(tokenIndex++));
        objRecord.setDatatypeName((String)tokens.get(tokenIndex++));
        objRecord.setDatatypeID((String)tokens.get(tokenIndex++));
        objRecord.setRuntimeType((String)tokens.get(tokenIndex++));
        objRecord.setResourcePath((String)tokens.get(tokenIndex++));
        objRecord.setMetaclassURI((String)tokens.get(tokenIndex++));
        return objRecord;
    }

    public static AnnotatedObjectRecord createAnnotatedObjectRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        AnnotatedObjectRecordImpl annotRecord = new AnnotatedObjectRecordImpl();
        int tokenIndex = 1;
        annotRecord.setUUID((String)tokens.get(tokenIndex++));
        annotRecord.setName((String)tokens.get(tokenIndex++));
        annotRecord.setFullname((String)tokens.get(tokenIndex++));
        annotRecord.setObjectURI((String)tokens.get(tokenIndex++));
        annotRecord.setProperties(SearchRuntimeAdapter.getProperties((String)tokens.get(tokenIndex++), '\u001f', '\u2060'));
        annotRecord.setDescription((String)tokens.get(tokenIndex++));
        annotRecord.setResourcePath((String)tokens.get(tokenIndex++));
        annotRecord.setMetaclassURI((String)tokens.get(tokenIndex++));
        return annotRecord;
    }

    public static ReferencesRecord createResourceObjRefRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ReferencesRecordImpl refRecord = new ReferencesRecordImpl();
        int tokenIndex = 1;
        refRecord.setReferencedUUID((String)tokens.get(tokenIndex++));
        refRecord.setUUID((String)tokens.get(tokenIndex++));
        return refRecord;
    }

    public static ResourceObjectRecord createResourceObjectRecord(EObject theEObject) {
        ResourceObjectRecordImpl objRecord = new ResourceObjectRecordImpl();
        ModelEditor editor = ModelerCore.getModelEditor();
        objRecord.setUUID(ModelerCore.getObjectIdString(theEObject));
        objRecord.setObjectURI(editor.getUri(theEObject).toFileString());
        objRecord.setMetaclassURI(theEObject.eClass().getName());
        SqlAspect sqlAspect = AspectManager.getSqlAspect(theEObject);
        String name = sqlAspect == null ? editor.getName(theEObject) : sqlAspect.getName(theEObject);
        objRecord.setName(name);
        String fullName = sqlAspect == null ? null : sqlAspect.getFullName(theEObject);
        objRecord.setFullname(fullName);
        String path = sqlAspect == null ? editor.getModelRelativePathIncludingModel(theEObject).toString() : sqlAspect.getPath(theEObject).toString();
        objRecord.setResourcePath(path);
        return objRecord;
    }

    public static ResourceRecord createResourceRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ResourceRecordImpl resourceRecord = new ResourceRecordImpl();
        int tokenIndex = 1;
        resourceRecord.setUUID((String)tokens.get(tokenIndex++));
        resourceRecord.setPath((String)tokens.get(tokenIndex++));
        resourceRecord.setURI((String)tokens.get(tokenIndex++));
        resourceRecord.setMetamodelURI((String)tokens.get(tokenIndex++));
        resourceRecord.setModelType((String)tokens.get(tokenIndex++));
        return resourceRecord;
    }

    public static ResourceImportRecord createResourceImportRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        ResourceImportRecordImpl importRecord = new ResourceImportRecordImpl();
        int tokenIndex = 1;
        importRecord.setImportedPath((String)tokens.get(tokenIndex++));
        importRecord.setUUID((String)tokens.get(tokenIndex++));
        importRecord.setPath((String)tokens.get(tokenIndex++));
        return importRecord;
    }

    public static RelationshipRecord createRelationshipRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        RelationshipRecordImpl relationRecord = new RelationshipRecordImpl();
        int tokenIndex = 1;
        relationRecord.setUUID((String)tokens.get(tokenIndex++));
        relationRecord.setName((String)tokens.get(tokenIndex++));
        int n = ++tokenIndex;
        relationRecord.setTypeUUID((String)tokens.get(n));
        int n2 = ++tokenIndex;
        relationRecord.setTypeName((String)tokens.get(n2));
        int n3 = ++tokenIndex;
        relationRecord.setUri((String)tokens.get(n3));
        int n4 = ++tokenIndex;
        ++tokenIndex;
        relationRecord.setResourcePath((String)tokens.get(n4));
        return relationRecord;
    }

    public static RelationshipTypeRecord createRelationshipTypeRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        RelationshipTypeRecordImpl relationTypeRecord = new RelationshipTypeRecordImpl();
        int tokenIndex = 1;
        relationTypeRecord.setName((String)tokens.get(tokenIndex++));
        relationTypeRecord.setSuperTypeUUID((String)tokens.get(tokenIndex++));
        relationTypeRecord.setUUID((String)tokens.get(tokenIndex++));
        relationTypeRecord.setSourceRoleName((String)tokens.get(tokenIndex++));
        relationTypeRecord.setTargetRoleName((String)tokens.get(tokenIndex++));
        relationTypeRecord.setUri((String)tokens.get(tokenIndex++));
        return relationTypeRecord;
    }

    public static RelatedObjectRecord createRelatedObjectRecord(char[] record) {
        String str = new String(record);
        List tokens = CoreStringUtil.split((String)str, (String)String.valueOf('\u00a0'));
        RelatedObjectRecordImpl relatedRecord = new RelatedObjectRecordImpl();
        int tokenIndex = 1;
        relatedRecord.setUUID((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedObjectUUID((String)tokens.get(tokenIndex++));
        relatedRecord.setRelationshipUUID((String)tokens.get(tokenIndex++));
        char[] booleanValues = ((String)tokens.get(tokenIndex++)).toCharArray();
        relatedRecord.setSourceObject(SearchRuntimeAdapter.getBooleanValue((char)booleanValues[0]));
        relatedRecord.setMetaClassUri((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedMetaClassUri((String)tokens.get(tokenIndex++));
        relatedRecord.setRoleName((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedRoleName((String)tokens.get(tokenIndex++));
        relatedRecord.setName((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedObjectName((String)tokens.get(tokenIndex++));
        relatedRecord.setUri((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedObjectUri((String)tokens.get(tokenIndex++));
        relatedRecord.setResourcePath((String)tokens.get(tokenIndex++));
        relatedRecord.setRelatedResourcePath((String)tokens.get(tokenIndex++));
        return relatedRecord;
    }
}

