/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.resource.EmfResourceSet;
import org.teiid.designer.core.transaction.SourcedNotificationImpl;
import org.teiid.designer.core.transaction.TransactionStateConstants;
import org.teiid.designer.core.transaction.TxnNotificationFilter;
import org.teiid.designer.core.transaction.UndoableImpl;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.transaction.UnitOfWorkProviderImpl;
import org.teiid.designer.core.util.ExternalResourceImportsHelper;
import org.teiid.designer.core.util.ProcessedNotificationResult;

public class UnitOfWorkImpl
implements UnitOfWork {
    private final TxnNotificationFilter filter;
    private final Set resourcesChanged;
    private final Collection removedEObjects;
    private Object id;
    private int state;
    private CompoundCommand txnCommand;
    private Container container;
    private boolean significant;
    private boolean isUndoable;
    private String description;
    private Object source;
    private boolean overrideRollback;
    private final Set processedNotificationResults;

    public UnitOfWorkImpl(ResourceSet resources) {
        this(resources, Integer.MAX_VALUE);
    }

    public UnitOfWorkImpl(ResourceSet resources, int waitTimeouts) {
        if (resources == null) {
            String msg = ModelerCore.Util.getString("UnitOfWorkImpl.The_ResourceSet_reference_may_not_be_null", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        this.resourcesChanged = new HashSet();
        this.removedEObjects = new HashSet();
        if (resources instanceof EmfResourceSet) {
            this.container = ((EmfResourceSet)resources).getContainer();
        } else {
            try {
                this.container = ModelerCore.getModelContainer();
            }
            catch (CoreException err) {
                throw new TeiidDesignerRuntimeException((Throwable)err);
            }
        }
        this.filter = new TxnNotificationFilter(resources);
        this.setState(-1);
        this.isUndoable = true;
        this.processedNotificationResults = new HashSet();
    }

    public Collection getRemovedEObjects() {
        return new HashSet(this.removedEObjects);
    }

    @Override
    public void begin() {
        if (this.isStarted()) {
            CoreArgCheck.isTrue((boolean)false, (String)ModelerCore.Util.getString("UnitOfWorkImpl.Transaction_already_started_1", new Object[0]));
        }
        if (this.state != 4 && this.state != -1 && this.state != 5) {
            throw new ModelerCoreRuntimeException(ModelerCore.Util.getString("UnitOfWorkImpl.Invalid_transaction_state_prior_to_begin", (Object)TransactionStateConstants.getDisplayValue(this.state)));
        }
        this.description = null;
        this.id = UnitOfWorkProviderImpl.getIdFactory().create();
        this.significant = true;
        this.isUndoable = true;
        this.filter.clear();
        this.resourcesChanged.clear();
        this.removedEObjects.clear();
        this.setState(1);
        this.overrideRollback = false;
        this.processedNotificationResults.clear();
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void processNotification(Notification notification) throws ModelerCoreException {
        if (!(this.isStarted() || this.isRollingBack() || this.isCommitting())) {
            int preState = this.getState();
            this.setState(5);
            throw new ModelerCoreException(ModelerCore.Util.getString("UnitOfWorkImpl.Invalid_transaction_state_prior_to_processing_notification", (Object)TransactionStateConstants.getDisplayValue(preState)));
        }
        CoreArgCheck.isNotNull((Object)notification);
        if (notification.getNotifier() instanceof Resource && notification.getEventType() == 1 && notification.getFeatureID(Resource.class) == 3) {
            if (notification.getNewBooleanValue()) {
                this.resourcesChanged.add(notification.getNotifier());
            } else {
                this.resourcesChanged.remove(notification.getNotifier());
            }
        }
        this.filter.addNotification(notification);
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public void setSource(Object object) {
        this.source = object;
    }

    @Override
    public void commit() throws ModelerCoreException {
        block19: {
            block18: {
                boolean success = false;
                try {
                    try {
                        if (!this.isStarted() && !this.isRollingBack()) {
                            int preState = this.getState();
                            throw new ModelerCoreException(ModelerCore.Util.getString("UnitOfWorkImpl.Invalid_transaction_state_prior_to_commit", (Object)TransactionStateConstants.getDisplayValue(preState)));
                        }
                        this.postProcessNotificationResults();
                        this.setState(2);
                        if (!this.overrideRollback && this.txnCommand != null && this.isUndoable) {
                            UnitOfWorkProviderImpl uowp = (UnitOfWorkProviderImpl)this.container.getEmfTransactionProvider();
                            UndoableImpl undoable = new UndoableImpl(this.container, this.txnCommand, new ArrayList(this.resourcesChanged), this.id, this.source);
                            undoable.setSignificant(this.significant);
                            if (this.description != null) {
                                undoable.setDescription(this.description);
                            }
                            this.txnCommand = null;
                            uowp.processUndoable(undoable);
                        }
                        success = true;
                    }
                    catch (Throwable e) {
                        success = false;
                        this.setState(5);
                        this.rollback();
                        throw new ModelerCoreException(e, ModelerCore.Util.getString("UnitOfWorkImpl.Error_committing_transaction", new Object[0]));
                    }
                }
                finally {
                    if (!success) break block18;
                    this.setState(4);
                    try {
                        List notifications = this.filter.getSourcedNotifications(this.source);
                        if (ModelerCore.DEBUG_NOTIFICATIONS) {
                            this.helpPrintFilterResults(notifications, this.description);
                        }
                        if (notifications.isEmpty()) break block19;
                        ChangeNotifier notifier = this.container.getChangeNotifier();
                        try {
                            for (Notification n : notifications) {
                                notifier.fireNotifyChanged(n);
                            }
                            break block19;
                        }
                        catch (Throwable e1) {
                            ModelerCore.Util.log(4, e1, ModelerCore.Util.getString("UnitOfWorkImpl.Error_processing_notification_1", new Object[0]));
                        }
                    }
                    catch (Throwable e1) {
                        ModelerCore.Util.log(4, e1, String.valueOf(ModelerCore.Util.getString("UnitOfWorkImpl.Error_processing_notifications____1", new Object[0])) + e1.getMessage());
                    }
                    break block19;
                }
            }
            this.setState(5);
        }
        this.filter.clear();
        this.cleanup();
    }

    public void helpPrintFilterResults(List sns, String description) {
        if (sns == null || sns.isEmpty()) {
            return;
        }
        if (!CoreStringUtil.isEmpty((String)description)) {
            System.out.println("\n" + description);
            System.out.println("TxnNotificationFilter result:");
        } else {
            System.out.println("\nTxnNotificationFilter result:");
        }
        for (SourcedNotificationImpl sn : sns) {
            System.out.println(sn.getNotifier());
            System.out.println("   primary notification: " + sn.getPrimaryNotification());
            for (Notification n : sn.getNotifications()) {
                System.out.println("      notification: " + n);
            }
        }
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void rollback() {
        block10: {
            boolean success = false;
            try {
                try {
                    if (!this.isStarted() && !this.isFailed()) {
                        int preState = this.getState();
                        throw new ModelerCoreException(ModelerCore.Util.getString("UnitOfWorkImpl.Invalid_transaction_state_prior_to_rollback", (Object)TransactionStateConstants.getDisplayValue(preState)));
                    }
                    this.setState(3);
                    if (!this.overrideRollback && this.txnCommand != null && !this.txnCommand.isEmpty()) {
                        CompoundCommand tmp = this.txnCommand;
                        this.txnCommand = null;
                        tmp.undo();
                    }
                    this.filter.clear();
                    this.txnCommand = null;
                    this.cleanup();
                    success = true;
                }
                catch (Exception e) {
                    success = false;
                    ModelerCore.Util.log(4, (Throwable)e, ModelerCore.Util.getString("UnitOfWorkImpl.Error_rolling_back_transaction", new Object[0]));
                    if (success) {
                        this.setState(4);
                        break block10;
                    }
                    this.setState(5);
                }
            }
            finally {
                if (success) {
                    this.setState(4);
                } else {
                    this.setState(5);
                }
            }
        }
    }

    @Override
    public boolean executeCommand(Command command) throws ModelerCoreException {
        if (!this.isStarted() && !this.isRollingBack()) {
            int preState = this.getState();
            this.setState(5);
            throw new ModelerCoreException(ModelerCore.Util.getString("UnitOfWorkImpl.Transaction_must_be_started_before_you_can_execute_commands", (Object)TransactionStateConstants.getDisplayValue(preState)));
        }
        if (!command.canExecute()) {
            String msg = ModelerCore.Util.getString("UnitOfWorkImpl.Command_object_not_executable", (Object)command);
            if (ModelerCore.DEBUG) {
                ModelerCore.Util.log(4, msg);
            }
            command.dispose();
            throw new ModelerCoreException(msg);
        }
        if (!this.overrideRollback) {
            if (this.txnCommand == null) {
                this.txnCommand = new CompoundCommand(command.getLabel());
            }
            this.txnCommand.append(command);
        }
        try {
            command.execute();
        }
        catch (RuntimeException exception) {
            Object[] params = new Object[]{command, exception.getMessage()};
            String msg = ModelerCore.Util.getString("UnitOfWorkImpl.error_executing_command", params);
            command.dispose();
            throw new ModelerCoreException((Throwable)exception, msg);
        }
        this.updateRemovedEObjects(command);
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.getState() == 1;
    }

    @Override
    public boolean isCommitting() {
        return this.getState() == 2;
    }

    @Override
    public boolean isComplete() {
        return this.getState() == 4;
    }

    @Override
    public boolean isRollingBack() {
        return this.getState() == 3;
    }

    @Override
    public boolean isFailed() {
        return this.getState() == 5;
    }

    @Override
    public boolean requiresStart() {
        switch (this.state) {
            case 2: {
                return false;
            }
            case 1: {
                return false;
            }
            case 3: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void setSignificant(boolean b) throws ModelerCoreException {
        if (!this.isStarted()) {
            int preState = this.getState();
            throw new ModelerCoreException(ModelerCore.Util.getString("UnitOfWorkImpl.Invalid_Unit_of_Work_State___May_only_set_isSignificant_on_started_Unit_of_Work_3", (Object)TransactionStateConstants.getDisplayValue(preState)));
        }
        this.significant = b;
    }

    @Override
    public boolean isUndoable() {
        return this.isUndoable;
    }

    @Override
    public void setUndoable(boolean b) {
        this.isUndoable = b;
    }

    public boolean isOverrideRollback() {
        return this.overrideRollback;
    }

    public void setOverrideRollback(boolean b) {
        this.overrideRollback = b;
    }

    public String toString() {
        if (this.description == null) {
            return String.valueOf(this.getClass().getName()) + " : " + TransactionStateConstants.getDisplayValue(this.getState());
        }
        return String.valueOf(this.description) + " : " + TransactionStateConstants.getDisplayValue(this.getState());
    }

    public int getState() {
        return this.state;
    }

    public void addProcessedNotificationResult(ProcessedNotificationResult result) {
        if (this.processedNotificationResults.isEmpty()) {
            this.processedNotificationResults.add(result);
        } else {
            boolean foundMatchingResource = false;
            ProcessedNotificationResult nextResult2 = null;
            for (ProcessedNotificationResult nextResult2 : this.processedNotificationResults) {
                if (nextResult2.getTargetResource() == result.getTargetResource()) {
                    foundMatchingResource = true;
                    nextResult2.addDereferencedResources(result.getDereferencedResources());
                }
                if (foundMatchingResource) break;
            }
            if (!foundMatchingResource) {
                this.processedNotificationResults.add(result);
            }
        }
    }

    private void postProcessNotificationResults() {
        if (!this.processedNotificationResults.isEmpty()) {
            ExternalResourceImportsHelper.processNotificationResults(this.processedNotificationResults);
        }
        this.processedNotificationResults.clear();
    }

    private void setState(int state) {
        this.state = state;
        if (ModelerCore.DEBUG_TRANSACTION) {
            switch (state) {
                case 5: {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("UnitOfWorkImpl.Setting_state_to_FAILED_12", new Object[0]));
                    Thread.dumpStack();
                    break;
                }
                case 1: {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("UnitOfWorkImpl.Setting_state_to_STARTED_13", new Object[0]));
                    break;
                }
                case 4: {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("UnitOfWorkImpl.Setting_state_to_COMPLETE_14", new Object[0]));
                    break;
                }
                case 2: {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("UnitOfWorkImpl.Setting_state_to_COMMITTING_15", new Object[0]));
                    break;
                }
                case 3: {
                    ModelerCore.Util.log(1, ModelerCore.Util.getString("UnitOfWorkImpl.Setting_state_to_ROLLING_BACK_16", new Object[0]));
                    break;
                }
            }
        }
    }

    private void cleanup() {
        this.id = null;
        this.significant = true;
        this.isUndoable = true;
        this.source = null;
        this.removedEObjects.clear();
        this.resourcesChanged.clear();
        this.filter.clear();
        this.container.getEmfTransactionProvider().cleanup(Thread.currentThread());
    }

    private void updateRemovedEObjects(Command cmd) {
        if (cmd instanceof RemoveCommand) {
            EList ownerList;
            RemoveCommand remove = (RemoveCommand)cmd;
            Collection list = remove.getCollection();
            EStructuralFeature sf = remove.getFeature();
            if (sf != null && sf instanceof EReference) {
                EReference ref = (EReference)sf;
                if (ref.isContainment()) {
                    this.removedEObjects.addAll(list);
                } else if (ref.isContainer()) {
                    this.removedEObjects.addAll(list);
                }
            } else if (list != null && !list.isEmpty() && (ownerList = remove.getOwnerList()) instanceof EcoreEList) {
                EcoreEList eList = (EcoreEList)ownerList;
                EStructuralFeature listSf = eList.getEStructuralFeature();
                for (Object next : list) {
                    EReference ownerSf;
                    if (!(next instanceof EObject) || (ownerSf = ((EObject)next).eContainmentFeature()) != listSf || ownerSf == null) continue;
                    this.removedEObjects.add(next);
                }
            }
        } else if (cmd instanceof SetCommand) {
            SetCommand set = (SetCommand)cmd;
            EStructuralFeature sf = set.getFeature();
            if (sf instanceof EReference) {
                EReference ref = (EReference)sf;
                if (ref.isContainment() || ref.isContainer()) {
                    Object oldVal = set.getOldValue();
                    if (oldVal != null && set.getValue() == null) {
                        if (oldVal instanceof Collection) {
                            this.removedEObjects.addAll((Collection)oldVal);
                        } else if (oldVal instanceof EObject) {
                            this.removedEObjects.add(oldVal);
                        }
                    } else if (oldVal == null && set.getValue() != null) {
                        Object val = set.getValue();
                        if (val instanceof Collection) {
                            this.removedEObjects.removeAll((Collection)val);
                        } else if (val instanceof EObject) {
                            this.removedEObjects.remove(val);
                        }
                    }
                } else if (ref.isContainer()) {
                    Object oldVal = set.getOldValue();
                    if (oldVal != null && set.getValue() == null) {
                        this.removedEObjects.add(set.getOwner());
                    } else if (oldVal == null && set.getValue() != null) {
                        this.removedEObjects.remove(set.getOwner());
                    }
                }
            }
        } else if (cmd instanceof AddCommand) {
            this.removedEObjects.removeAll(((AddCommand)cmd).getCollection());
        }
    }
}

