/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.teiid.core.designer.id.LongIDFactory;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.transaction.Undoable;
import org.teiid.designer.core.transaction.UndoableListener;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.transaction.UnitOfWorkImpl;
import org.teiid.designer.core.transaction.UnitOfWorkProvider;

public class UnitOfWorkProviderImpl
implements UnitOfWorkProvider {
    private static final boolean DEBUG = false;
    private static final HashMap current = new HashMap();
    private final ResourceSet resources;
    private final Collection undoableListeners;
    private static LongIDFactory idFactory = new LongIDFactory();

    public UnitOfWorkProviderImpl(ResourceSet resources) {
        CoreArgCheck.isNotNull((Object)resources, (String)ModelerCore.Util.getString("UnitOfWorkProviderImpl.ResourceSet_may_not_be_null_during_SimpleEmfUnitOfWorkProvider_construction_1", new Object[0]));
        this.resources = resources;
        this.undoableListeners = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnitOfWork getCurrent() {
        UnitOfWork uow = null;
        HashMap hashMap = current;
        synchronized (hashMap) {
            Iterator threads = current.entrySet().iterator();
            while (threads.hasNext()) {
                Map.Entry entry = threads.next();
                if (entry.getKey() == Thread.currentThread()) {
                    uow = (UnitOfWork)entry.getValue();
                    if (!uow.isComplete()) continue;
                    uow = null;
                    continue;
                }
                if (((Thread)entry.getKey()).isAlive()) continue;
                threads.remove();
            }
            if (uow == null) {
                uow = new UnitOfWorkImpl(this.resources);
                current.put(Thread.currentThread(), uow);
            }
        }
        return uow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup(Thread thread) {
        HashMap hashMap = current;
        synchronized (hashMap) {
            current.remove(thread);
        }
    }

    @Override
    public void addUndoableEditListener(UndoableListener listener) {
        if (!this.undoableListeners.contains(listener)) {
            this.undoableListeners.add(listener);
        }
    }

    @Override
    public void removeUndoableEditListener(UndoableListener listener) {
        if (this.undoableListeners.contains(listener)) {
            this.undoableListeners.remove(listener);
        }
    }

    public synchronized void processUndoable(Undoable undoable) {
        for (UndoableListener next : this.undoableListeners) {
            next.process(undoable);
        }
    }

    public static LongIDFactory getIdFactory() {
        return idFactory;
    }

    public static void setIdFactory(LongIDFactory factory) {
        idFactory = factory;
    }
}

