/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.translators;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.translators.TranslatorPropertyDefinition;

public class TranslatorOverrideProperty {
    private final ListenerList listeners;
    private String overriddenValue;
    private TranslatorPropertyDefinition propDefn;

    public TranslatorOverrideProperty(TranslatorPropertyDefinition propDefn, String overriddenValue) {
        CoreArgCheck.isNotNull((Object)propDefn);
        this.propDefn = propDefn;
        this.overriddenValue = overriddenValue;
        this.listeners = new ListenerList();
    }

    public void addListener(PropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.propDefn.getId().equals(((TranslatorOverrideProperty)obj).getDefinition().getId());
    }

    public TranslatorPropertyDefinition getDefinition() {
        return this.propDefn;
    }

    public String getOverriddenValue() {
        return this.isCustom() && StringUtilities.isEmpty((String)this.overriddenValue) ? this.getDefinition().getDefaultValue() : this.overriddenValue;
    }

    public int hashCode() {
        return this.getDefinition().getId().hashCode();
    }

    public boolean hasOverridenValue() {
        if (this.isCustom()) {
            assert (!StringUtilities.isEmpty((String)this.getOverriddenValue()));
            return true;
        }
        return !StringUtilities.isEmpty((String)this.getOverriddenValue());
    }

    public boolean isCustom() {
        return this.propDefn.isUserDefined();
    }

    public void removeListener(PropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setDefinition(PropertyDefinition propDefn) {
        assert (propDefn != null);
        this.propDefn = new TranslatorPropertyDefinition(propDefn);
    }

    public void setValue(String newValue) {
        if (!StringUtilities.equals((String)this.overriddenValue, (String)newValue)) {
            String oldValue = this.overriddenValue;
            this.overriddenValue = newValue;
            PropertyChangeEvent event = new PropertyChangeEvent(this, this.propDefn.getId(), oldValue, newValue);
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((PropertyChangeListener)listener).propertyChange(event);
                ++n2;
            }
        }
    }
}

