/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.translators;

import org.teiid.core.designer.properties.PropertyDefinition;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;

public class TranslatorProperty
implements PropertyDefinition {
    private final String className;
    boolean advanced;
    String[] allowedValues;
    String defaultValue;
    String description;
    String displayName;
    String id;
    boolean masked;
    boolean modifiable;
    boolean required;

    public TranslatorProperty(String className) {
        this.className = className;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id.equals(((TranslatorProperty)obj).id);
    }

    public String[] getAllowedValues() {
        return this.allowedValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public boolean isMasked() {
        return this.masked;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getClassName() {
        return this.className;
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public void setAllowedValues(String[] allowedValues) {
        this.allowedValues = allowedValues;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMasked(boolean masked) {
        this.masked = masked;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String isValidValue(String newValue) {
        if (StringUtilities.isEmpty((String)newValue)) {
            if (this.isRequired() && StringUtilities.isEmpty((String)this.getDefaultValue())) {
                return ModelerCore.Util.getString("invalidNullPropertyValue", (Object)this.getDisplayName());
            }
            return null;
        }
        if (Boolean.class.getName().equals(this.className) || Boolean.TYPE.getName().equals(this.className)) {
            if (!newValue.equalsIgnoreCase(Boolean.TRUE.toString()) && !newValue.equalsIgnoreCase(Boolean.FALSE.toString())) {
                return ModelerCore.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Boolean.TYPE.getName()});
            }
        } else if (Character.class.getName().equals(this.className) || Character.TYPE.getName().equals(this.className)) {
            if (newValue.length() != 1) {
                return ModelerCore.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Character.TYPE.getName()});
            }
        } else if (Byte.class.getName().equals(this.className) || Byte.TYPE.getName().equals(this.className)) {
            try {
                Byte.parseByte(newValue);
            }
            catch (Exception exception) {
                return ModelerCore.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Byte.TYPE.getName()});
            }
        } else if (Short.class.getName().equals(this.className) || Short.TYPE.getName().equals(this.className)) {
            try {
                Short.parseShort(newValue);
            }
            catch (Exception exception) {
                return ModelerCore.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Short.TYPE.getName()});
            }
        } else if (Integer.class.getName().equals(this.className) || Integer.TYPE.getName().equals(this.className)) {
            try {
                Integer.parseInt(newValue);
            }
            catch (Exception exception) {
                return ModelerCore.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Integer.TYPE.getName()});
            }
        } else if (Long.class.getName().equals(this.className) || Long.TYPE.getName().equals(this.className)) {
            try {
                Long.parseLong(newValue);
            }
            catch (Exception exception) {
                return ModelerCore.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Long.TYPE.getName()});
            }
        } else if (Float.class.getName().equals(this.className) || Float.TYPE.getName().equals(this.className)) {
            try {
                Float.parseFloat(newValue);
            }
            catch (Exception exception) {
                return ModelerCore.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Float.TYPE.getName()});
            }
        } else if (Double.class.getName().equals(this.className) || Double.TYPE.getName().equals(this.className)) {
            try {
                Double.parseDouble(newValue);
            }
            catch (Exception exception) {
                return ModelerCore.Util.getString("invalidPropertyValueForType", new Object[]{newValue, Double.TYPE.getName()});
            }
        } else if (!String.class.getName().equals(this.className)) {
            return ModelerCore.Util.getString("unknownPropertyType", new Object[]{this.displayName, this.className});
        }
        return null;
    }
}

