/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.Arrays;
import org.eclipse.emf.common.util.URI;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.UriPathConverter;

public class BasicUriPathConverter
implements UriPathConverter {
    private static final String SEGMENT_EMPTY = "";
    private static final String SEGMENT_SELF = ".";
    private static final String SEGMENT_PARENT = "..";
    private static final char SEGMENT_SEPARATOR = '/';

    @Override
    public String makeAbsolute(String relativePath, String basePath) {
        CoreArgCheck.isNotNull((Object)relativePath);
        URI relativeURI = URI.createURI((String)relativePath);
        if (relativeURI.hasAbsolutePath()) {
            return relativePath;
        }
        CoreArgCheck.isNotNull((Object)basePath);
        URI baseURI = URI.createURI((String)basePath);
        return this.makeAbsolute(relativeURI, baseURI).toString();
    }

    @Override
    public URI makeAbsolute(URI relativeURI, URI baseURI) {
        CoreArgCheck.isNotNull((Object)relativeURI);
        if (relativeURI.hasAbsolutePath()) {
            return relativeURI;
        }
        CoreArgCheck.isNotNull((Object)baseURI);
        if (baseURI.isRelative()) {
            String[] segments = this.mergePath(relativeURI, baseURI, true);
            StringBuffer sb = new StringBuffer(200);
            int i = 0;
            while (i != segments.length) {
                sb.append('/');
                sb.append(segments[i]);
                ++i;
            }
            return URI.createURI((String)sb.toString());
        }
        return relativeURI.resolve(baseURI);
    }

    @Override
    public String makeRelative(String absolutePath, String basePath) {
        CoreArgCheck.isNotNull((Object)absolutePath);
        URI absoluteURI = URI.createURI((String)absolutePath);
        URI baseURI = URI.createURI((String)basePath);
        return this.makeRelative(absoluteURI, baseURI).toString();
    }

    @Override
    public URI makeRelative(URI absoluteURI, URI baseURI) {
        CoreArgCheck.isNotNull((Object)absoluteURI);
        CoreArgCheck.isNotNull((Object)baseURI);
        CoreArgCheck.isNotNull((Object)baseURI);
        if (baseURI.isRelative()) {
            String[] segments = this.findRelativePath(absoluteURI, baseURI, true);
            StringBuffer sb = new StringBuffer(200);
            String seg = segments[0];
            if (!(segments.length <= 1 || SEGMENT_SELF.equals(seg) || SEGMENT_PARENT.equals(seg) || SEGMENT_EMPTY.equals(seg))) {
                sb.append('/');
            }
            int i = 0;
            while (i != segments.length) {
                seg = segments[i];
                if (i > 0) {
                    sb.append('/');
                }
                sb.append(seg);
                ++i;
            }
            return URI.createURI((String)sb.toString());
        }
        return absoluteURI.deresolve(baseURI);
    }

    private String[] mergePath(URI relativeURI, URI baseURI, boolean preserveRootParents) {
        int segmentCount = relativeURI.segmentCount();
        String[] segments = relativeURI.segments();
        int baseSegmentCount = baseURI.segmentCount();
        String[] stack = new String[baseSegmentCount + segmentCount];
        int sp = 0;
        int i = 0;
        while (i < baseSegmentCount - 1) {
            sp = BasicUriPathConverter.accumulate(stack, sp, baseURI.segment(i), preserveRootParents);
            ++i;
        }
        i = 0;
        while (i < segmentCount) {
            sp = BasicUriPathConverter.accumulate(stack, sp, segments[i], preserveRootParents);
            ++i;
        }
        if (sp > 0 && (segmentCount == 0 || SEGMENT_EMPTY.equals(segments[segmentCount - 1]) || SEGMENT_PARENT.equals(segments[segmentCount - 1]) || SEGMENT_SELF.equals(segments[segmentCount - 1]))) {
            stack[sp++] = SEGMENT_EMPTY;
        }
        String[] result = new String[sp];
        System.arraycopy(stack, 0, result, 0, sp);
        return result;
    }

    private static int accumulate(String[] stack, int sp, String segment, boolean preserveRootParents) {
        if (SEGMENT_PARENT.equals(segment)) {
            if (sp == 0) {
                if (preserveRootParents) {
                    stack[sp++] = segment;
                }
            } else if (SEGMENT_PARENT.equals(stack[sp - 1])) {
                stack[sp++] = segment;
            } else {
                --sp;
            }
        } else if (!SEGMENT_EMPTY.equals(segment) && !SEGMENT_SELF.equals(segment)) {
            stack[sp++] = segment;
        }
        return sp;
    }

    private String[] findRelativePath(URI absoluteURI, URI baseURI, boolean preserveRootParents) {
        String[] segments = absoluteURI.segments();
        String[] startPath = this.collapseSegments(baseURI, preserveRootParents);
        String[] endPath = segments;
        int startCount = startPath.length > 0 ? startPath.length - 1 : 0;
        int endCount = endPath.length;
        int diff = 0;
        int count = startCount < endCount ? startCount : endCount - 1;
        while (diff < count && startPath[diff].equals(endPath[diff])) {
            ++diff;
        }
        int upCount = startCount - diff;
        int downCount = endCount - diff;
        if (downCount == 1 && SEGMENT_EMPTY.equals(endPath[endCount - 1])) {
            downCount = 0;
        }
        if (upCount + downCount == 0) {
            return new String[]{SEGMENT_SELF};
        }
        Object[] result = new String[upCount + downCount];
        Arrays.fill(result, 0, upCount, SEGMENT_PARENT);
        System.arraycopy(endPath, diff, result, upCount, downCount);
        return result;
    }

    String[] collapseSegments(URI uri, boolean preserveRootParents) {
        String[] segments = uri.segments();
        if (!this.hasCollapsableSegments(uri, preserveRootParents)) {
            return segments;
        }
        int segmentCount = segments.length;
        String[] stack = new String[segmentCount];
        int sp = 0;
        int i = 0;
        while (i < segmentCount) {
            sp = BasicUriPathConverter.accumulate(stack, sp, segments[i], preserveRootParents);
            ++i;
        }
        if (sp > 0 && (SEGMENT_EMPTY.equals(segments[segmentCount - 1]) || SEGMENT_PARENT.equals(segments[segmentCount - 1]) || SEGMENT_SELF.equals(segments[segmentCount - 1]))) {
            stack[sp++] = SEGMENT_EMPTY;
        }
        String[] result = new String[sp];
        System.arraycopy(stack, 0, result, 0, sp);
        return result;
    }

    private boolean hasCollapsableSegments(URI uri, boolean preserveRootParents) {
        String[] segments = uri.segments();
        int i = 0;
        int len = segments.length;
        while (i < len) {
            String segment = segments[i];
            if (i < len - 1 && SEGMENT_EMPTY.equals(segment) || SEGMENT_SELF.equals(segment) || SEGMENT_PARENT.equals(segment) && (!preserveRootParents || i != 0 && !SEGMENT_PARENT.equals(segments[i - 1]))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

