/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.util.ModelVisitorWithFinish;

public class ConcurrentModelVisitorProcessor
extends ModelVisitorProcessor {
    public ConcurrentModelVisitorProcessor(ModelVisitor visitor) {
        this(visitor, 0);
    }

    public ConcurrentModelVisitorProcessor(ModelVisitor visitor, int mode) {
        super(visitor, mode);
    }

    @Override
    public void walk(Resource startingResource, int depth) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)startingResource);
        this.assertValidDepth(depth);
        if (!this.getModelVisitor().visit(startingResource) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        Object[] children = startingResource.getContents().toArray();
        int i = 0;
        while (i != children.length) {
            Object obj = children[i];
            if (obj instanceof EObject) {
                this.walk((EObject)obj, nextDepth);
            }
            ++i;
        }
    }

    @Override
    public void walk(EObject startingObject, int depth) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)startingObject);
        this.assertValidDepth(depth);
        if (!this.visitor.visit(startingObject) || depth == 0) {
            return;
        }
        int nextDepth = depth == 2 ? 2 : 0;
        Object children = this.navigator.getChildren(startingObject);
        if (children instanceof List) {
            Object[] tmp = ((List)children).toArray();
            int i = 0;
            while (i != tmp.length) {
                Object obj = tmp[i];
                if (obj instanceof EObject) {
                    this.walk((EObject)obj, nextDepth);
                }
                ++i;
            }
        } else if (children instanceof EObject) {
            this.walk((EObject)children, nextDepth);
        }
        if (this.visitor instanceof ModelVisitorWithFinish) {
            ((ModelVisitorWithFinish)this.visitor).postVisit(startingObject);
        }
    }
}

