/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.PropertyChangePublisher;
import org.teiid.designer.core.spi.RegistrySPI;

public class FlatRegistry
implements RegistrySPI {
    private Map entries = new HashMap();

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        CoreArgCheck.isNotNull((Object)evt.getOldValue());
        CoreArgCheck.isNotNull((Object)evt.getNewValue());
        CoreArgCheck.isNotNull((Object)evt.getPropertyName());
        CoreArgCheck.isNotNull((Object)evt.getSource());
        this.register(evt.getNewValue().toString(), (PropertyChangePublisher)evt.getSource(), evt.getPropertyName());
        if (evt.getOldValue() != null && this.lookup(evt.getOldValue().toString()) == evt.getSource()) {
            this.entries.remove(evt.getOldValue().toString());
        }
    }

    @Override
    public Object lookup(String key) {
        CoreArgCheck.isNotNull((Object)key);
        return this.entries.get(key);
    }

    @Override
    public <T> T lookup(String key, Class<T> klazz) {
        CoreArgCheck.isNotNull((Object)key);
        CoreArgCheck.isNotNull(klazz);
        Object obj = this.entries.get(key);
        if (obj == null) {
            return null;
        }
        if (!klazz.isInstance(obj)) {
            return null;
        }
        return (T)obj;
    }

    @Override
    public <T> T register(String key, T obj) {
        CoreArgCheck.isNotNull((Object)key);
        this.entries.put(key, obj);
        return obj;
    }

    @Override
    public PropertyChangePublisher register(String key, PropertyChangePublisher propertyChangePublisher, String propertyName) {
        CoreArgCheck.isNotNull((Object)key);
        CoreArgCheck.isNotNull((Object)propertyChangePublisher);
        CoreArgCheck.isNotNull((Object)propertyName);
        this.entries.put(key, propertyChangePublisher);
        propertyChangePublisher.addPropertyChangeListener(propertyName, this);
        return propertyChangePublisher;
    }

    @Override
    public Object unregister(String key) {
        CoreArgCheck.isNotNull((Object)key);
        Object object = this.entries.remove(key);
        if (object instanceof PropertyChangePublisher) {
            ((PropertyChangePublisher)object).removePropertyChangeListener(this);
        }
        return object;
    }

    public int size() {
        return this.entries.size();
    }
}

