/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.ImportsAspect;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ExternalResourceImportsHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelImport;

public class ImportUtilities {
    public static boolean addMissingImport(Resource resource, Resource externalResource) {
        ModelImport existingImport;
        if (externalResource == null || resource.getURI().isRelative() || externalResource.getURI().isRelative()) {
            return false;
        }
        boolean wasAdded = false;
        if (resource instanceof EmfResource && (existingImport = ModelerCore.getModelEditor().findModelImport((EmfResource)resource, externalResource)) == null) {
            try {
                wasAdded = ModelerCore.getModelEditor().addModelImport((EmfResource)resource, externalResource);
                if (wasAdded) {
                    ImportUtilities.addMissingDependentImports(resource, externalResource);
                }
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
        return wasAdded;
    }

    private static void addMissingDependentImports(Resource resource, Resource externalResource) {
        ModelResource depResource = null;
        if (externalResource instanceof XSDResourceImpl && ((XSDResourceImpl)externalResource).getSchema() != null) {
            for (EObject eobject : ((XSDResourceImpl)externalResource).getSchema().getContents()) {
                IPath importPath;
                if (eobject instanceof XSDAnnotation) continue;
                if (eobject instanceof XSDNamedComponent) break;
                ImportsAspect importsAspect = AspectManager.getModelImportsAspect(eobject);
                if (importsAspect == null || (importPath = importsAspect.getModelPath(eobject)) == null) continue;
                depResource = ModelerCore.getModelWorkspace().findModelResource(importPath);
            }
        }
        if (depResource != null) {
            try {
                ImportUtilities.addMissingImport(resource, depResource.getEmfResource());
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
    }

    public static boolean removeExistingImport(Resource resource, Resource externalResource) {
        ModelImport existingImport;
        if (externalResource == null || resource.getURI().isRelative() || externalResource.getURI().isRelative()) {
            return false;
        }
        boolean wasRemoved = false;
        if (resource instanceof EmfResource && (existingImport = ModelerCore.getModelEditor().findModelImport((EmfResource)resource, externalResource)) != null) {
            try {
                ModelAnnotation modelWithImports = ((EmfResource)resource).getModelAnnotation();
                if (modelWithImports != null) {
                    ModelerCore.getModelEditor().removeValue(modelWithImports, existingImport, modelWithImports.getModelImports());
                    wasRemoved = true;
                }
                if (wasRemoved) {
                    ImportUtilities.addMissingDependentImports(resource, externalResource);
                }
            }
            catch (ModelerCoreException e) {
                ModelerCore.Util.log((Throwable)e);
            }
        }
        return wasRemoved;
    }

    public static boolean addMissingImports(Resource notifyingResource, Object target) {
        Collection externalResources = ExternalResourceImportsHelper.findExternalResourceReferences(notifyingResource, target);
        boolean result = false;
        if (!externalResources.isEmpty()) {
            Resource targetResource = null;
            if (target instanceof EObject) {
                targetResource = ((EObject)target).eResource();
            } else if (target instanceof Resource) {
                targetResource = (Resource)target;
            } else if (target instanceof ModelResource) {
                try {
                    targetResource = ((ModelResource)target).getEmfResource();
                }
                catch (ModelWorkspaceException theException) {
                    ModelerCore.Util.log(4, (Throwable)((Object)theException), theException.getLocalizedMessage());
                }
            }
            boolean importWasAdded = false;
            if (targetResource != null && targetResource instanceof EmfResource) {
                Iterator iter = externalResources.iterator();
                while (iter.hasNext()) {
                    importWasAdded = ImportUtilities.addMissingImport(targetResource, (Resource)iter.next());
                    if (!importWasAdded) continue;
                    result = true;
                }
            }
        }
        return result;
    }
}

