/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.util.ModelVisitor;

public class ModelObjectClassNameVisitor
implements ModelVisitor {
    private final Collection<String> classNames;
    private Collection<EObject> result;

    public ModelObjectClassNameVisitor(Collection<String> classNames) {
        CoreArgCheck.isNotNull(classNames, (String)"classNames is null");
        CoreArgCheck.isTrue((!classNames.isEmpty() ? 1 : 0) != 0, (String)"className is empty");
        this.classNames = classNames;
    }

    public Collection<EObject> getResult() {
        return this.result == null ? Collections.emptyList() : this.result;
    }

    @Override
    public boolean visit(EObject object) {
        String className = object.getClass().getName();
        if (this.classNames.contains(className)) {
            if (this.result == null) {
                this.result = new ArrayList<EObject>();
            }
            this.result.add(object);
        }
        return true;
    }

    @Override
    public boolean visit(Resource resource) {
        return true;
    }
}

