/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.resource.Resource;

public class ProcessedNotificationResult {
    private Collection dereferencedResources = new HashSet();
    private Resource targetResource;
    private boolean importsWereAdded = false;

    public ProcessedNotificationResult(Resource target) {
        this.targetResource = target;
    }

    public ProcessedNotificationResult(ProcessedNotificationResult result) {
        this.targetResource = result.getTargetResource();
        this.dereferencedResources.addAll(result.getDereferencedResources());
    }

    public Resource getTargetResource() {
        return this.targetResource;
    }

    public Collection getDereferencedResources() {
        return this.dereferencedResources;
    }

    public void addDereferencedResource(Resource resource) {
        if (resource != null) {
            this.dereferencedResources.add(resource);
        }
    }

    public void removeDereferencedResource(Resource resource) {
        if (resource != null) {
            this.dereferencedResources.remove(resource);
        }
    }

    public void addDereferencedResources(Collection resources) {
        if (resources != null && !resources.isEmpty()) {
            this.dereferencedResources.addAll(resources);
        }
    }

    public boolean importsWereAdded() {
        return this.importsWereAdded;
    }

    public void setImportsWereAdded(boolean theImportsWereAdded) {
        this.importsWereAdded = theImportsWereAdded;
    }
}

