/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.plugin.PluginUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.resource.xmi.MtkXmiResourceImpl;
import org.teiid.designer.core.workspace.ModelStatusImpl;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class Util {
    public static CoreException newCoreException(int errorCode, String msg) {
        return new ModelWorkspaceException(new ModelStatusImpl(errorCode, msg));
    }

    public static CoreException newCoreException(int errorCode, Throwable t, String msg) {
        return new ModelWorkspaceException(new ModelStatusImpl(errorCode, t, msg));
    }

    public static void loadExtensionMap(String extensionPointID, Map extensionMap) {
        if (extensionPointID == null) {
            String msg = ModelerCore.Util.getString("Util.The_extension_ID_may_not_be_null_1", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        if (extensionMap == null) {
            String msg = ModelerCore.Util.getString("Util.The_Map_reference_may_not_be_null_2", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        IExtension[] extensions = PluginUtilities.getExtensions((String)extensionPointID);
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            String uniqueID = extension.getUniqueIdentifier();
            extensionMap.put(uniqueID, extension);
            ++i;
        }
    }

    public static Object createExtensionInstance(String uniqueID, Map extensionMap) throws CoreException {
        if (uniqueID == null) {
            String msg = ModelerCore.Util.getString("Util.The_extension_uniqueID_may_not_be_null_3", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        if (extensionMap == null) {
            String msg = ModelerCore.Util.getString("Util.The_Map_reference_may_not_be_null_4", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        IExtension extension = (IExtension)extensionMap.get(uniqueID);
        if (extension == null) {
            throw Util.newCoreException(1, String.valueOf(ModelerCore.Util.getString("Util.Unable_to_find_an_extension_with_unique_ID___5", new Object[0])) + uniqueID + "\"");
        }
        return Util.createExecutableExtension(extension);
    }

    public static Object createExecutableExtension(IExtension extension) throws CoreException {
        if (extension == null) {
            String msg = ModelerCore.Util.getString("Util.The_IExtension_reference_may_not_be_null_7", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        try {
            return PluginUtilities.createExecutableExtension((IExtension)extension, (String)"class", (String)"name");
        }
        catch (CoreException coreException) {
            throw Util.newCoreException(1, String.valueOf(ModelerCore.Util.getString("Util.Error_creating_instance_of_extension_with_ID___10", new Object[0])) + extension.getUniqueIdentifier() + "\"");
        }
    }

    public static ModelAnnotation getModelAnnotation(Resource resource) {
        ModelAnnotation modelAnnotation = null;
        if (resource instanceof MtkXmiResourceImpl) {
            modelAnnotation = ((MtkXmiResourceImpl)resource).getModelAnnotation();
        } else {
            for (Object next : resource.getContents()) {
                if (!(next instanceof ModelAnnotation)) continue;
                modelAnnotation = (ModelAnnotation)next;
                break;
            }
        }
        return modelAnnotation;
    }
}

