/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.core.ModelerCore;

public class VdbHelper
implements StringConstants {
    public static final String JAR_EXT = "jar";
    public static final String JAR_MIME_TYPE = "application/java-archive";
    public static final FileFilter JAR_FILE_FILTER = new FileFilter("jar", "*.jar");
    public static final FileFilter ALL_FILE_FILTER = new FileFilter("All files", "*.*");

    public static List<IResource> getUdfJarResources(IProject project) {
        ArrayList<IResource> jarResources = new ArrayList<IResource>();
        IContainer jarFolder = VdbHelper.getFolder(project, VdbFolders.UDF.getReadFolder());
        if (jarFolder != null) {
            try {
                IResource[] folderEntries = jarFolder.members();
                int j = 0;
                while (j < folderEntries.length) {
                    IResource folderEntry = folderEntries[j];
                    if (folderEntry instanceof IFile && ((IFile)folderEntry).getFileExtension().equalsIgnoreCase(JAR_EXT)) {
                        jarResources.add(folderEntry);
                    }
                    ++j;
                }
            }
            catch (CoreException ex) {
                ModelerCore.Util.log(4, (Throwable)ex, ModelerCore.Util.getString("VdbHelper.errorWithJarLookupInFolder", (Object)jarFolder.getName()));
            }
        }
        return jarResources;
    }

    public static IContainer getFolder(IProject project, String folderName) {
        if (folderName == null || ".".equals(folderName)) {
            return project;
        }
        IFolder libFolder = null;
        if (project != null) {
            IResource[] resources = null;
            try {
                resources = project.members();
            }
            catch (CoreException coreException) {
                return null;
            }
            if (resources != null) {
                int i = 0;
                while (i < resources.length) {
                    IResource theResc = resources[i];
                    if (theResc instanceof IFolder && folderName.equalsIgnoreCase(((IFolder)theResc).getName())) {
                        libFolder = (IFolder)theResc;
                        break;
                    }
                    ++i;
                }
            }
        }
        return libFolder;
    }

    public static File findVdbFile(String filePath, IProject project) {
        IPath locationPath;
        IFile file;
        String thePath;
        File theFile = null;
        if (!(filePath == null || filePath.trim().isEmpty() || (theFile = new File(thePath = filePath.toString())).exists() || (file = project.getFile((IPath)new Path(thePath))) == null || (locationPath = file.getLocation()) == null || (theFile = locationPath.toFile()).exists())) {
            theFile = null;
        }
        return theFile;
    }

    public static String getFileRelativePath(IContainer folder, String fileName) {
        String relativePath = null;
        if (folder != null) {
            try {
                IResource[] folderEntries = folder.members();
                int j = 0;
                while (j < folderEntries.length) {
                    IResource folderEntry = folderEntries[j];
                    if (folderEntry instanceof IFile && ((IFile)folderEntry).getName().equalsIgnoreCase(fileName)) {
                        relativePath = folderEntry.getProjectRelativePath().toString();
                        break;
                    }
                    ++j;
                }
            }
            catch (CoreException ex) {
                ModelerCore.Util.log(4, (Throwable)ex, ModelerCore.Util.getString("VdbHelper.errorGettingFileRelativePath", (Object)fileName));
            }
        }
        return relativePath;
    }

    public static boolean isFileInFolder(IContainer folder, String fileName) {
        boolean found = false;
        if (folder != null) {
            try {
                IResource[] folderEntries = folder.members();
                int j = 0;
                while (j < folderEntries.length) {
                    IResource folderEntry = folderEntries[j];
                    if (folderEntry instanceof IFile && ((IFile)folderEntry).getProjectRelativePath().toString().equalsIgnoreCase(fileName)) {
                        found = true;
                        break;
                    }
                    ++j;
                }
            }
            catch (CoreException ex) {
                ModelerCore.Util.log(4, (Throwable)ex, ModelerCore.Util.getString("VdbHelper.errorWithFileLookupInFolder", (Object)folder.getName()));
            }
        }
        return found;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean folderContainsOneOrMoreFile(IContainer folder, String extension) {
        boolean contains = false;
        if (folder == null) return contains;
        try {
            IResource[] folderEntries = folder.members();
            int j = 0;
            while (true) {
                if (j >= folderEntries.length) {
                    return contains;
                }
                IResource folderEntry = folderEntries[j];
                if (folderEntry instanceof IFile) {
                    if (extension == null) {
                        return true;
                    }
                    IFile file = (IFile)folderEntry;
                    if (file.getFileExtension().equalsIgnoreCase(extension)) {
                        return true;
                    }
                }
                ++j;
            }
        }
        catch (CoreException ex) {
            ModelerCore.Util.log(4, (Throwable)ex, ModelerCore.Util.getString("VdbHelper.errorWithFileLookupInFolder", (Object)folder.getName()));
        }
        return contains;
    }

    public static class FileFilter {
        private String name;
        private String filter;

        public FileFilter(String name, String filter) {
            this.name = name;
            this.filter = filter;
        }

        public String getName() {
            return this.name;
        }

        public String getFilter() {
            return this.filter;
        }
    }

    public static enum VdbFolders {
        UDF("lib", "lib", JAR_FILE_FILTER, "jar"),
        OTHER_FILES(".", "otherFiles", ALL_FILE_FILTER, null);

        private String readFolder;
        private String writeFolder;
        private FileFilter fileFilter;
        private String extension;

        private VdbFolders(String readFolder, String writeFolder, FileFilter fileFilter, String extension) {
            this.readFolder = readFolder;
            this.writeFolder = writeFolder;
            this.fileFilter = fileFilter;
            this.extension = extension;
        }

        public String getReadFolder() {
            return this.readFolder;
        }

        public String getWriteFolder() {
            return this.writeFolder;
        }

        public String toString() {
            return this.readFolder;
        }

        public FileFilter getFileFilter() {
            return this.fileFilter;
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

