/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationResult;

public class ValidationContext {
    private static final Resource[] EMPTY_RESOURCE_ARRAY = new Resource[0];
    private String preferenceQualifier;
    private Map<String, Integer> preferenceStatusMap;
    private List validationResults;
    private Map rulesRun;
    private Map targetTransformMap;
    private Map targetValidationResults;
    private Resource[] resourcesToValidate;
    private Resource[] resourcesInScope = EMPTY_RESOURCE_ARRAY;
    private Container resourceContainer;
    private boolean useServerIndexes = false;
    private boolean useIndexesToResolve = true;
    private boolean cacheMappingRootResults = true;
    private String indexDirectory = IndexUtil.INDEX_PATH;
    private Collection uuidsInContext = null;
    private Collection objectsToIgnore = null;
    private Map dataMap;

    public ValidationContext() {
        this(null);
    }

    public ValidationContext(String preferenceQualifier) {
        this.preferenceQualifier = preferenceQualifier;
        this.preferenceStatusMap = new HashMap<String, Integer>();
    }

    public void addUuidToContext(String uuidString) {
        if (this.uuidsInContext == null) {
            this.uuidsInContext = new HashSet();
        }
        this.uuidsInContext.add(uuidString);
    }

    public boolean containsUuid(String uuidString) {
        if (this.uuidsInContext != null) {
            return this.uuidsInContext.contains(uuidString);
        }
        return false;
    }

    public Resource[] getResourcesToValidate() {
        if (this.resourcesToValidate == null) {
            this.resourcesToValidate = EMPTY_RESOURCE_ARRAY;
        }
        return this.resourcesToValidate;
    }

    public void setResourcesToValidate(Resource[] eResourcesToValidate) {
        this.resourcesToValidate = eResourcesToValidate;
    }

    public void setResourcesInScope(Resource[] theResources) {
        this.resourcesInScope = theResources == null ? EMPTY_RESOURCE_ARRAY : theResources;
    }

    public Resource[] getResourcesInScope() {
        return this.resourcesInScope;
    }

    public boolean shouldIgnore(Object object) {
        if (this.objectsToIgnore != null) {
            return this.objectsToIgnore.contains(object);
        }
        return false;
    }

    public void addObjectToIgnore(EObject eObject, boolean recursive) {
        if (eObject != null) {
            if (this.objectsToIgnore == null) {
                this.objectsToIgnore = new HashSet();
            }
            this.objectsToIgnore.add(eObject);
            if (recursive) {
                Iterator iter = eObject.eContents().iterator();
                while (iter.hasNext()) {
                    this.addObjectToIgnore((EObject)iter.next(), recursive);
                }
            }
        }
    }

    public Container getResourceContainer() {
        return this.resourceContainer;
    }

    public void setResourceContainer(Container container) {
        this.resourceContainer = container;
    }

    public DatatypeManager getDatatypeManager() {
        DatatypeManager dtMgr = null;
        if (this.getResourceContainer() != null) {
            dtMgr = this.getResourceContainer().getDatatypeManager();
        }
        CoreArgCheck.isNotNull(dtMgr);
        return dtMgr;
    }

    public boolean cacheMappingRootResults() {
        return this.cacheMappingRootResults;
    }

    public void setCacheMappingRootResults(boolean cacheMappingRootResults) {
        this.cacheMappingRootResults = cacheMappingRootResults;
    }

    public void setIndexLocation(String location) {
        this.indexDirectory = location;
    }

    public String getIndexLocation() {
        return this.indexDirectory;
    }

    public boolean useIndexesToResolve() {
        return this.useIndexesToResolve;
    }

    public void setUseIndexesToResolve(boolean useIndexesToResolve) {
        this.useIndexesToResolve = useIndexesToResolve;
    }

    public boolean useServerIndexes() {
        return this.useServerIndexes;
    }

    public void setUseServerIndexes(boolean useServerIndexes) {
        this.useServerIndexes = useServerIndexes;
    }

    public boolean hasPreferences() {
        return this.preferenceQualifier != null;
    }

    public String getPreferenceValue(String key) {
        CoreArgCheck.isNotNull((Object)key, (String)"key");
        if (this.hasPreferences()) {
            String value = ModelerCore.getPreferences(this.preferenceQualifier).get(key, null);
            if (CoreStringUtil.isEmpty((String)value)) {
                value = ModelerCore.getDefaultPreferences(this.preferenceQualifier).get(key, null);
            }
            return value;
        }
        return null;
    }

    public int getPreferenceStatus(String prefKey, int defaultStatus) {
        if (this.hasPreferences()) {
            if (this.preferenceStatusMap.containsKey(prefKey)) {
                return this.preferenceStatusMap.get(prefKey);
            }
            String value = this.getPreferenceValue(prefKey);
            if (value != null) {
                if (value.equals("ignore")) {
                    this.preferenceStatusMap.put(prefKey, 0);
                    return 0;
                }
                if (value.equals("info")) {
                    this.preferenceStatusMap.put(prefKey, 1);
                    return 1;
                }
                if (value.equals("warning")) {
                    this.preferenceStatusMap.put(prefKey, 2);
                    return 2;
                }
                if (value.equals("error")) {
                    this.preferenceStatusMap.put(prefKey, 4);
                    return 4;
                }
            }
        }
        this.preferenceStatusMap.put(prefKey, new Integer(defaultStatus));
        return defaultStatus;
    }

    protected String getValidationDescriptorValue(int statusValue) {
        switch (statusValue) {
            case 0: {
                return "ignore";
            }
            case 1: {
                return "info";
            }
            case 2: {
                return "warning";
            }
            case 4: {
                return "error";
            }
        }
        return "";
    }

    public void clearResults() {
        if (this.validationResults != null) {
            this.validationResults.clear();
        }
        if (this.targetValidationResults != null) {
            this.targetValidationResults.clear();
        }
    }

    public void clearState() {
        this.clearResults();
        if (this.rulesRun != null) {
            this.rulesRun.clear();
        }
        if (this.targetTransformMap != null) {
            this.targetTransformMap.clear();
        }
        this.resourcesToValidate = null;
        this.preferenceQualifier = null;
        this.preferenceStatusMap.clear();
        this.resourceContainer = null;
        this.useServerIndexes = false;
        this.useIndexesToResolve = true;
        this.indexDirectory = IndexUtil.INDEX_PATH;
        this.uuidsInContext = null;
        this.dataMap = null;
    }

    public boolean hasResults() {
        return this.validationResults != null && !this.validationResults.isEmpty();
    }

    public void addResult(ValidationResult result) {
        CoreArgCheck.isNotNull((Object)result);
        if (result.hasProblems()) {
            if (this.validationResults == null) {
                this.validationResults = new ArrayList();
            }
            this.validationResults.add(result);
            this.updateTargetResults(result.getTarget(), result);
        }
    }

    public ValidationResult getLastResult() {
        if (this.validationResults == null || this.validationResults.isEmpty()) {
            return null;
        }
        return (ValidationResult)this.validationResults.get(this.validationResults.size() - 1);
    }

    public List getValidationResults() {
        return this.validationResults;
    }

    public boolean hasRunRule(EObject eObject, String ruleName) {
        CoreArgCheck.isNotNull((Object)eObject);
        if (this.rulesRun != null) {
            String containerInfo = this.getContainerInfo(eObject);
            return this.hasRunRule(containerInfo, ruleName);
        }
        return false;
    }

    public boolean hasRunRule(String containerInfo, String ruleName) {
        Collection ruleNames;
        CoreArgCheck.isNotNull((Object)containerInfo);
        return this.rulesRun != null && (ruleNames = (Collection)this.rulesRun.get(containerInfo)) != null && ruleNames.contains(ruleName);
    }

    private String getContainerInfo(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        EObject container = eObject.eContainer();
        if (container != null) {
            return ModelerCore.getObjectIdString(container);
        }
        return eObject.eResource().getURI().toString();
    }

    public void recordRuleRun(EObject eObject, String ruleName) {
        CoreArgCheck.isNotNull((Object)eObject);
        String containerInfo = this.getContainerInfo(eObject);
        this.recordRuleRun(containerInfo, ruleName);
    }

    public void recordRuleRun(String containerInfo, String ruleName) {
        HashSet<String> ruleNames;
        CoreArgCheck.isNotNull((Object)containerInfo);
        if (this.rulesRun == null) {
            this.rulesRun = new HashMap();
        }
        if ((ruleNames = (HashSet<String>)this.rulesRun.get(containerInfo)) == null) {
            ruleNames = new HashSet<String>(1);
        }
        ruleNames.add(ruleName);
        this.rulesRun.put(containerInfo, ruleNames);
    }

    public Map getTargetTransformMap() {
        return this.targetTransformMap;
    }

    public void addTargetTransform(EObject target, EObject transform) {
        if (this.targetTransformMap == null) {
            this.targetTransformMap = new HashMap();
        }
        if (target != null) {
            this.targetTransformMap.put(target, transform);
        }
    }

    public Collection getTargetResults(EObject target) {
        if (this.targetValidationResults != null) {
            return (Collection)this.targetValidationResults.get(target);
        }
        return Collections.EMPTY_LIST;
    }

    public IStatus getTargetStatus(EObject target) {
        MultiStatus status = new MultiStatus("org.teiid.designer.core", 0, "", null);
        Collection results = this.getTargetResults(target);
        if (results != null && !results.isEmpty()) {
            for (ValidationResult result : results) {
                ValidationProblem[] problems = result.getProblems();
                int i = 0;
                while (i < problems.length) {
                    status.add(problems[i].getStatus());
                    ++i;
                }
            }
        }
        return status;
    }

    protected void updateTargetResults(Object target, ValidationResult validationResult) {
        HashSet<ValidationResult> results;
        if (this.targetValidationResults == null) {
            this.targetValidationResults = new HashMap();
        }
        if ((results = (HashSet<ValidationResult>)this.targetValidationResults.get(target)) == null) {
            results = new HashSet<ValidationResult>(1);
        }
        results.add(validationResult);
        this.targetValidationResults.put(target, results);
    }

    public Object getData(String theKey) {
        return this.dataMap == null ? null : this.dataMap.get(theKey);
    }

    public void setData(String theKey, Object theValue) {
        CoreArgCheck.isNotNull((Object)theKey);
        if (this.dataMap == null) {
            this.dataMap = new HashMap();
        }
        this.dataMap.put(theKey, theValue);
    }
}

