/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.ValidationProblem;

public class ValidationProblemImpl
implements ValidationProblem {
    private final int code;
    private final int severity;
    private final String message;
    private boolean hasPreference;
    private final String uri;
    private final String location;

    public ValidationProblemImpl(IStatus status) {
        this(status.getCode(), status.getSeverity(), status.getMessage());
    }

    public ValidationProblemImpl(int code, int severity, String message) {
        this(code, severity, message, null, null);
    }

    public ValidationProblemImpl(int code, int severity, String message, String location, String uri) {
        this.validateSeverity(severity);
        this.code = code;
        this.severity = severity;
        this.message = message;
        this.uri = uri;
        this.location = location;
    }

    private void validateSeverity(int severity) {
        if (severity == 4 || severity == 1 || severity == 0 || severity == 2) {
            return;
        }
        throw new IllegalArgumentException(ModelerCore.Util.getString("ValidationProblemImpl.Invalid_severity.__Value_must_be_one_of_valid_status_constants_from_IStatus_class_1", new Object[0]));
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        if (!this.hasPreference) {
            return this.message;
        }
        return String.valueOf(this.message) + ModelerCore.Util.getString("ValidationProblemImpl.option_preference", new Object[0]);
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public void setHasPreference(boolean hasPreference) {
        this.hasPreference = hasPreference;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getSeverityString());
        buffer.append(" - ");
        buffer.append(this.getMessage());
        return buffer.toString();
    }

    private String getSeverityString() {
        switch (this.severity) {
            case 4: {
                return ModelerCore.Util.getString("ValidationProblemImpl.Error_1", new Object[0]);
            }
            case 1: {
                return ModelerCore.Util.getString("ValidationProblemImpl.Info_2", new Object[0]);
            }
            case 0: {
                return ModelerCore.Util.getString("ValidationProblemImpl.OK_3", new Object[0]);
            }
            case 2: {
                return ModelerCore.Util.getString("ValidationProblemImpl.Warning_4", new Object[0]);
            }
        }
        return ModelerCore.Util.getString("ValidationProblemImpl.Unknown_Severity_5", new Object[0]);
    }

    @Override
    public IStatus getStatus() {
        return new Status(this.severity, "org.teiid.designer.core", this.code, this.message, null);
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

